// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The MultiLanguageAnalysisInput model.
 */
@Fluent
public final class MultiLanguageAnalysisInput implements JsonSerializable<MultiLanguageAnalysisInput> {
    /*
     * The documents property.
     */
    private List<MultiLanguageInput> documents;

    /**
     * Creates an instance of MultiLanguageAnalysisInput class.
     */
    public MultiLanguageAnalysisInput() {
    }

    /**
     * Get the documents property: The documents property.
     * 
     * @return the documents value.
     */
    public List<MultiLanguageInput> getDocuments() {
        return this.documents;
    }

    /**
     * Set the documents property: The documents property.
     * 
     * @param documents the documents value to set.
     * @return the MultiLanguageAnalysisInput object itself.
     */
    public MultiLanguageAnalysisInput setDocuments(List<MultiLanguageInput> documents) {
        this.documents = documents;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MultiLanguageAnalysisInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MultiLanguageAnalysisInput if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MultiLanguageAnalysisInput.
     */
    public static MultiLanguageAnalysisInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MultiLanguageAnalysisInput deserializedMultiLanguageAnalysisInput = new MultiLanguageAnalysisInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("documents".equals(fieldName)) {
                    List<MultiLanguageInput> documents
                        = reader.readArray(reader1 -> MultiLanguageInput.fromJson(reader1));
                    deserializedMultiLanguageAnalysisInput.documents = documents;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMultiLanguageAnalysisInput;
        });
    }
}
