// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Supported parameters for a PII Entities Recognition task.
 */
@Fluent
public final class PiiTaskParameters extends PreBuiltTaskParameters {
    /*
     * The PII domain used for PII Entity Recognition.
     */
    private PiiDomain domain;

    /*
     * (Optional) describes the PII categories to return
     */
    private List<PiiCategory> piiCategories;

    /*
     * Specifies the method used to interpret string offsets.  Defaults to Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see https://aka.ms/text-analytics-offsets.
     */
    private StringIndexType stringIndexType;

    /**
     * Creates an instance of PiiTaskParameters class.
     */
    public PiiTaskParameters() {
    }

    /**
     * Get the domain property: The PII domain used for PII Entity Recognition.
     * 
     * @return the domain value.
     */
    public PiiDomain getDomain() {
        return this.domain;
    }

    /**
     * Set the domain property: The PII domain used for PII Entity Recognition.
     * 
     * @param domain the domain value to set.
     * @return the PiiTaskParameters object itself.
     */
    public PiiTaskParameters setDomain(PiiDomain domain) {
        this.domain = domain;
        return this;
    }

    /**
     * Get the piiCategories property: (Optional) describes the PII categories to return.
     * 
     * @return the piiCategories value.
     */
    public List<PiiCategory> getPiiCategories() {
        return this.piiCategories;
    }

    /**
     * Set the piiCategories property: (Optional) describes the PII categories to return.
     * 
     * @param piiCategories the piiCategories value to set.
     * @return the PiiTaskParameters object itself.
     */
    public PiiTaskParameters setPiiCategories(List<PiiCategory> piiCategories) {
        this.piiCategories = piiCategories;
        return this;
    }

    /**
     * Get the stringIndexType property: Specifies the method used to interpret string offsets. Defaults to Text
     * Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     * https://aka.ms/text-analytics-offsets.
     * 
     * @return the stringIndexType value.
     */
    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    /**
     * Set the stringIndexType property: Specifies the method used to interpret string offsets. Defaults to Text
     * Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     * https://aka.ms/text-analytics-offsets.
     * 
     * @param stringIndexType the stringIndexType value to set.
     * @return the PiiTaskParameters object itself.
     */
    public PiiTaskParameters setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PiiTaskParameters setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PiiTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("loggingOptOut", isLoggingOptOut());
        jsonWriter.writeStringField("modelVersion", getModelVersion());
        jsonWriter.writeStringField("domain", this.domain == null ? null : this.domain.toString());
        jsonWriter.writeArrayField("piiCategories", this.piiCategories,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("stringIndexType",
            this.stringIndexType == null ? null : this.stringIndexType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PiiTaskParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PiiTaskParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PiiTaskParameters.
     */
    public static PiiTaskParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PiiTaskParameters deserializedPiiTaskParameters = new PiiTaskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("loggingOptOut".equals(fieldName)) {
                    deserializedPiiTaskParameters.setLoggingOptOut(reader.getNullable(JsonReader::getBoolean));
                } else if ("modelVersion".equals(fieldName)) {
                    deserializedPiiTaskParameters.setModelVersion(reader.getString());
                } else if ("domain".equals(fieldName)) {
                    deserializedPiiTaskParameters.domain = PiiDomain.fromString(reader.getString());
                } else if ("piiCategories".equals(fieldName)) {
                    List<PiiCategory> piiCategories
                        = reader.readArray(reader1 -> PiiCategory.fromString(reader1.getString()));
                    deserializedPiiTaskParameters.piiCategories = piiCategories;
                } else if ("stringIndexType".equals(fieldName)) {
                    deserializedPiiTaskParameters.stringIndexType = StringIndexType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPiiTaskParameters;
        });
    }
}
