// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The PreBuiltResult model.
 */
@Fluent
public class PreBuiltResult implements JsonSerializable<PreBuiltResult> {
    /*
     * Errors by document id.
     */
    private List<DocumentError> errors;

    /*
     * if showStats=true was specified in the request this field will contain information about the request payload.
     */
    private RequestStatistics statistics;

    /*
     * This field indicates which model is used for scoring.
     */
    private String modelVersion;

    /**
     * Creates an instance of PreBuiltResult class.
     */
    public PreBuiltResult() {
    }

    /**
     * Get the errors property: Errors by document id.
     * 
     * @return the errors value.
     */
    public List<DocumentError> getErrors() {
        return this.errors;
    }

    /**
     * Set the errors property: Errors by document id.
     * 
     * @param errors the errors value to set.
     * @return the PreBuiltResult object itself.
     */
    public PreBuiltResult setErrors(List<DocumentError> errors) {
        this.errors = errors;
        return this;
    }

    /**
     * Get the statistics property: if showStats=true was specified in the request this field will contain information
     * about the request payload.
     * 
     * @return the statistics value.
     */
    public RequestStatistics getStatistics() {
        return this.statistics;
    }

    /**
     * Set the statistics property: if showStats=true was specified in the request this field will contain information
     * about the request payload.
     * 
     * @param statistics the statistics value to set.
     * @return the PreBuiltResult object itself.
     */
    public PreBuiltResult setStatistics(RequestStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    /**
     * Get the modelVersion property: This field indicates which model is used for scoring.
     * 
     * @return the modelVersion value.
     */
    public String getModelVersion() {
        return this.modelVersion;
    }

    /**
     * Set the modelVersion property: This field indicates which model is used for scoring.
     * 
     * @param modelVersion the modelVersion value to set.
     * @return the PreBuiltResult object itself.
     */
    public PreBuiltResult setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        jsonWriter.writeJsonField("statistics", this.statistics);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PreBuiltResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PreBuiltResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PreBuiltResult.
     */
    public static PreBuiltResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PreBuiltResult deserializedPreBuiltResult = new PreBuiltResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("errors".equals(fieldName)) {
                    List<DocumentError> errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    deserializedPreBuiltResult.errors = errors;
                } else if ("modelVersion".equals(fieldName)) {
                    deserializedPreBuiltResult.modelVersion = reader.getString();
                } else if ("statistics".equals(fieldName)) {
                    deserializedPreBuiltResult.statistics = RequestStatistics.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPreBuiltResult;
        });
    }
}
