// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SentenceAssessment model.
 */
@Fluent
public final class SentenceAssessment implements JsonSerializable<SentenceAssessment> {
    /*
     * Assessment sentiment in the sentence.
     */
    private TokenSentimentValue sentiment;

    /*
     * Assessment sentiment confidence scores in the sentence.
     */
    private TargetConfidenceScoreLabel confidenceScores;

    /*
     * The assessment offset from the start of the sentence.
     */
    private int offset;

    /*
     * The length of the assessment.
     */
    private int length;

    /*
     * The assessment text detected.
     */
    private String text;

    /*
     * The indicator representing if the assessment is negated.
     */
    private boolean isNegated;

    /**
     * Creates an instance of SentenceAssessment class.
     */
    public SentenceAssessment() {
    }

    /**
     * Get the sentiment property: Assessment sentiment in the sentence.
     * 
     * @return the sentiment value.
     */
    public TokenSentimentValue getSentiment() {
        return this.sentiment;
    }

    /**
     * Set the sentiment property: Assessment sentiment in the sentence.
     * 
     * @param sentiment the sentiment value to set.
     * @return the SentenceAssessment object itself.
     */
    public SentenceAssessment setSentiment(TokenSentimentValue sentiment) {
        this.sentiment = sentiment;
        return this;
    }

    /**
     * Get the confidenceScores property: Assessment sentiment confidence scores in the sentence.
     * 
     * @return the confidenceScores value.
     */
    public TargetConfidenceScoreLabel getConfidenceScores() {
        return this.confidenceScores;
    }

    /**
     * Set the confidenceScores property: Assessment sentiment confidence scores in the sentence.
     * 
     * @param confidenceScores the confidenceScores value to set.
     * @return the SentenceAssessment object itself.
     */
    public SentenceAssessment setConfidenceScores(TargetConfidenceScoreLabel confidenceScores) {
        this.confidenceScores = confidenceScores;
        return this;
    }

    /**
     * Get the offset property: The assessment offset from the start of the sentence.
     * 
     * @return the offset value.
     */
    public int getOffset() {
        return this.offset;
    }

    /**
     * Set the offset property: The assessment offset from the start of the sentence.
     * 
     * @param offset the offset value to set.
     * @return the SentenceAssessment object itself.
     */
    public SentenceAssessment setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    /**
     * Get the length property: The length of the assessment.
     * 
     * @return the length value.
     */
    public int getLength() {
        return this.length;
    }

    /**
     * Set the length property: The length of the assessment.
     * 
     * @param length the length value to set.
     * @return the SentenceAssessment object itself.
     */
    public SentenceAssessment setLength(int length) {
        this.length = length;
        return this;
    }

    /**
     * Get the text property: The assessment text detected.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The assessment text detected.
     * 
     * @param text the text value to set.
     * @return the SentenceAssessment object itself.
     */
    public SentenceAssessment setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the isNegated property: The indicator representing if the assessment is negated.
     * 
     * @return the isNegated value.
     */
    public boolean isNegated() {
        return this.isNegated;
    }

    /**
     * Set the isNegated property: The indicator representing if the assessment is negated.
     * 
     * @param isNegated the isNegated value to set.
     * @return the SentenceAssessment object itself.
     */
    public SentenceAssessment setIsNegated(boolean isNegated) {
        this.isNegated = isNegated;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sentiment", this.sentiment == null ? null : this.sentiment.toString());
        jsonWriter.writeJsonField("confidenceScores", this.confidenceScores);
        jsonWriter.writeIntField("offset", this.offset);
        jsonWriter.writeIntField("length", this.length);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeBooleanField("isNegated", this.isNegated);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SentenceAssessment from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SentenceAssessment if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SentenceAssessment.
     */
    public static SentenceAssessment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SentenceAssessment deserializedSentenceAssessment = new SentenceAssessment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sentiment".equals(fieldName)) {
                    deserializedSentenceAssessment.sentiment = TokenSentimentValue.fromString(reader.getString());
                } else if ("confidenceScores".equals(fieldName)) {
                    deserializedSentenceAssessment.confidenceScores = TargetConfidenceScoreLabel.fromJson(reader);
                } else if ("offset".equals(fieldName)) {
                    deserializedSentenceAssessment.offset = reader.getInt();
                } else if ("length".equals(fieldName)) {
                    deserializedSentenceAssessment.length = reader.getInt();
                } else if ("text".equals(fieldName)) {
                    deserializedSentenceAssessment.text = reader.getString();
                } else if ("isNegated".equals(fieldName)) {
                    deserializedSentenceAssessment.isNegated = reader.getBoolean();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSentenceAssessment;
        });
    }
}
