// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The SentenceSentiment model.
 */
@Fluent
public final class SentenceSentiment implements JsonSerializable<SentenceSentiment> {
    /*
     * The sentence text.
     */
    private String text;

    /*
     * The predicted Sentiment for the sentence.
     */
    private SentenceSentimentValue sentiment;

    /*
     * The sentiment confidence score between 0 and 1 for the sentence for all classes.
     */
    private SentimentConfidenceScorePerLabel confidenceScores;

    /*
     * The sentence offset from the start of the document.
     */
    private int offset;

    /*
     * The length of the sentence.
     */
    private int length;

    /*
     * The array of sentence targets for the sentence.
     */
    private List<SentenceTarget> targets;

    /*
     * The array of assessments for the sentence.
     */
    private List<SentenceAssessment> assessments;

    /**
     * Creates an instance of SentenceSentiment class.
     */
    public SentenceSentiment() {
    }

    /**
     * Get the text property: The sentence text.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The sentence text.
     * 
     * @param text the text value to set.
     * @return the SentenceSentiment object itself.
     */
    public SentenceSentiment setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the sentiment property: The predicted Sentiment for the sentence.
     * 
     * @return the sentiment value.
     */
    public SentenceSentimentValue getSentiment() {
        return this.sentiment;
    }

    /**
     * Set the sentiment property: The predicted Sentiment for the sentence.
     * 
     * @param sentiment the sentiment value to set.
     * @return the SentenceSentiment object itself.
     */
    public SentenceSentiment setSentiment(SentenceSentimentValue sentiment) {
        this.sentiment = sentiment;
        return this;
    }

    /**
     * Get the confidenceScores property: The sentiment confidence score between 0 and 1 for the sentence for all
     * classes.
     * 
     * @return the confidenceScores value.
     */
    public SentimentConfidenceScorePerLabel getConfidenceScores() {
        return this.confidenceScores;
    }

    /**
     * Set the confidenceScores property: The sentiment confidence score between 0 and 1 for the sentence for all
     * classes.
     * 
     * @param confidenceScores the confidenceScores value to set.
     * @return the SentenceSentiment object itself.
     */
    public SentenceSentiment setConfidenceScores(SentimentConfidenceScorePerLabel confidenceScores) {
        this.confidenceScores = confidenceScores;
        return this;
    }

    /**
     * Get the offset property: The sentence offset from the start of the document.
     * 
     * @return the offset value.
     */
    public int getOffset() {
        return this.offset;
    }

    /**
     * Set the offset property: The sentence offset from the start of the document.
     * 
     * @param offset the offset value to set.
     * @return the SentenceSentiment object itself.
     */
    public SentenceSentiment setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    /**
     * Get the length property: The length of the sentence.
     * 
     * @return the length value.
     */
    public int getLength() {
        return this.length;
    }

    /**
     * Set the length property: The length of the sentence.
     * 
     * @param length the length value to set.
     * @return the SentenceSentiment object itself.
     */
    public SentenceSentiment setLength(int length) {
        this.length = length;
        return this;
    }

    /**
     * Get the targets property: The array of sentence targets for the sentence.
     * 
     * @return the targets value.
     */
    public List<SentenceTarget> getTargets() {
        return this.targets;
    }

    /**
     * Set the targets property: The array of sentence targets for the sentence.
     * 
     * @param targets the targets value to set.
     * @return the SentenceSentiment object itself.
     */
    public SentenceSentiment setTargets(List<SentenceTarget> targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Get the assessments property: The array of assessments for the sentence.
     * 
     * @return the assessments value.
     */
    public List<SentenceAssessment> getAssessments() {
        return this.assessments;
    }

    /**
     * Set the assessments property: The array of assessments for the sentence.
     * 
     * @param assessments the assessments value to set.
     * @return the SentenceSentiment object itself.
     */
    public SentenceSentiment setAssessments(List<SentenceAssessment> assessments) {
        this.assessments = assessments;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("sentiment", this.sentiment == null ? null : this.sentiment.toString());
        jsonWriter.writeJsonField("confidenceScores", this.confidenceScores);
        jsonWriter.writeIntField("offset", this.offset);
        jsonWriter.writeIntField("length", this.length);
        jsonWriter.writeArrayField("targets", this.targets, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("assessments", this.assessments, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SentenceSentiment from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SentenceSentiment if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SentenceSentiment.
     */
    public static SentenceSentiment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SentenceSentiment deserializedSentenceSentiment = new SentenceSentiment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    deserializedSentenceSentiment.text = reader.getString();
                } else if ("sentiment".equals(fieldName)) {
                    deserializedSentenceSentiment.sentiment = SentenceSentimentValue.fromString(reader.getString());
                } else if ("confidenceScores".equals(fieldName)) {
                    deserializedSentenceSentiment.confidenceScores = SentimentConfidenceScorePerLabel.fromJson(reader);
                } else if ("offset".equals(fieldName)) {
                    deserializedSentenceSentiment.offset = reader.getInt();
                } else if ("length".equals(fieldName)) {
                    deserializedSentenceSentiment.length = reader.getInt();
                } else if ("targets".equals(fieldName)) {
                    List<SentenceTarget> targets = reader.readArray(reader1 -> SentenceTarget.fromJson(reader1));
                    deserializedSentenceSentiment.targets = targets;
                } else if ("assessments".equals(fieldName)) {
                    List<SentenceAssessment> assessments
                        = reader.readArray(reader1 -> SentenceAssessment.fromJson(reader1));
                    deserializedSentenceSentiment.assessments = assessments;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSentenceSentiment;
        });
    }
}
