// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the confidence scores between 0 and 1 across all sentiment classes: positive, neutral, negative.
 */
@Fluent
public final class SentimentConfidenceScorePerLabel implements JsonSerializable<SentimentConfidenceScorePerLabel> {
    /*
     * Confidence score for positive sentiment
     */
    private double positive;

    /*
     * Confidence score for neutral sentiment
     */
    private double neutral;

    /*
     * Confidence score for negative sentiment
     */
    private double negative;

    /**
     * Creates an instance of SentimentConfidenceScorePerLabel class.
     */
    public SentimentConfidenceScorePerLabel() {
    }

    /**
     * Get the positive property: Confidence score for positive sentiment.
     * 
     * @return the positive value.
     */
    public double getPositive() {
        return this.positive;
    }

    /**
     * Set the positive property: Confidence score for positive sentiment.
     * 
     * @param positive the positive value to set.
     * @return the SentimentConfidenceScorePerLabel object itself.
     */
    public SentimentConfidenceScorePerLabel setPositive(double positive) {
        this.positive = positive;
        return this;
    }

    /**
     * Get the neutral property: Confidence score for neutral sentiment.
     * 
     * @return the neutral value.
     */
    public double getNeutral() {
        return this.neutral;
    }

    /**
     * Set the neutral property: Confidence score for neutral sentiment.
     * 
     * @param neutral the neutral value to set.
     * @return the SentimentConfidenceScorePerLabel object itself.
     */
    public SentimentConfidenceScorePerLabel setNeutral(double neutral) {
        this.neutral = neutral;
        return this;
    }

    /**
     * Get the negative property: Confidence score for negative sentiment.
     * 
     * @return the negative value.
     */
    public double getNegative() {
        return this.negative;
    }

    /**
     * Set the negative property: Confidence score for negative sentiment.
     * 
     * @param negative the negative value to set.
     * @return the SentimentConfidenceScorePerLabel object itself.
     */
    public SentimentConfidenceScorePerLabel setNegative(double negative) {
        this.negative = negative;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("positive", this.positive);
        jsonWriter.writeDoubleField("neutral", this.neutral);
        jsonWriter.writeDoubleField("negative", this.negative);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SentimentConfidenceScorePerLabel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SentimentConfidenceScorePerLabel if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SentimentConfidenceScorePerLabel.
     */
    public static SentimentConfidenceScorePerLabel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SentimentConfidenceScorePerLabel deserializedSentimentConfidenceScorePerLabel
                = new SentimentConfidenceScorePerLabel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("positive".equals(fieldName)) {
                    deserializedSentimentConfidenceScorePerLabel.positive = reader.getDouble();
                } else if ("neutral".equals(fieldName)) {
                    deserializedSentimentConfidenceScorePerLabel.neutral = reader.getDouble();
                } else if ("negative".equals(fieldName)) {
                    deserializedSentimentConfidenceScorePerLabel.negative = reader.getDouble();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSentimentConfidenceScorePerLabel;
        });
    }
}
