// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The SentimentLROResult model.
 */
@Fluent
public final class SentimentLROResult extends AnalyzeTextLROResult {
    /*
     * Enumeration of supported Text Analysis long-running operation task results.
     */
    private AnalyzeTextLROResultsKind kind = AnalyzeTextLROResultsKind.SENTIMENT_ANALYSIS_LRORESULTS;

    /*
     * The results property.
     */
    private SentimentResponse results;

    /**
     * Creates an instance of SentimentLROResult class.
     */
    public SentimentLROResult() {
    }

    /**
     * Get the kind property: Enumeration of supported Text Analysis long-running operation task results.
     * 
     * @return the kind value.
     */
    @Override
    public AnalyzeTextLROResultsKind getKind() {
        return this.kind;
    }

    /**
     * Get the results property: The results property.
     * 
     * @return the results value.
     */
    public SentimentResponse getResults() {
        return this.results;
    }

    /**
     * Set the results property: The results property.
     * 
     * @param results the results value to set.
     * @return the SentimentLROResult object itself.
     */
    public SentimentLROResult setResults(SentimentResponse results) {
        this.results = results;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastUpdateDateTime",
            getLastUpdateDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getLastUpdateDateTime()));
        jsonWriter.writeStringField("status", getStatus() == null ? null : getStatus().toString());
        jsonWriter.writeStringField("taskName", getTaskName());
        jsonWriter.writeJsonField("results", this.results);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SentimentLROResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SentimentLROResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SentimentLROResult.
     */
    public static SentimentLROResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SentimentLROResult deserializedSentimentLROResult = new SentimentLROResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedSentimentLROResult.setLastUpdateDateTime(
                        reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                } else if ("status".equals(fieldName)) {
                    deserializedSentimentLROResult.setStatus(State.fromString(reader.getString()));
                } else if ("taskName".equals(fieldName)) {
                    deserializedSentimentLROResult.setTaskName(reader.getString());
                } else if ("results".equals(fieldName)) {
                    deserializedSentimentLROResult.results = SentimentResponse.fromJson(reader);
                } else if ("kind".equals(fieldName)) {
                    deserializedSentimentLROResult.kind = AnalyzeTextLROResultsKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSentimentLROResult;
        });
    }
}
