// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The SentimentResponseDocumentsItem model.
 */
@Fluent
public final class SentimentResponseDocumentsItem extends SentimentDocumentResult {
    /**
     * Creates an instance of SentimentResponseDocumentsItem class.
     */
    public SentimentResponseDocumentsItem() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentResponseDocumentsItem setSentiment(DocumentSentimentValue sentiment) {
        super.setSentiment(sentiment);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentResponseDocumentsItem setConfidenceScores(SentimentConfidenceScorePerLabel confidenceScores) {
        super.setConfidenceScores(confidenceScores);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentResponseDocumentsItem setSentences(List<SentenceSentiment> sentences) {
        super.setSentences(sentences);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentResponseDocumentsItem setId(String id) {
        super.setId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentResponseDocumentsItem setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentResponseDocumentsItem setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeArrayField("warnings", getWarnings(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("sentiment", getSentiment() == null ? null : getSentiment().toString());
        jsonWriter.writeJsonField("confidenceScores", getConfidenceScores());
        jsonWriter.writeArrayField("sentences", getSentences(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("statistics", getStatistics());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SentimentResponseDocumentsItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SentimentResponseDocumentsItem if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SentimentResponseDocumentsItem.
     */
    public static SentimentResponseDocumentsItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SentimentResponseDocumentsItem deserializedSentimentResponseDocumentsItem
                = new SentimentResponseDocumentsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSentimentResponseDocumentsItem.setId(reader.getString());
                } else if ("warnings".equals(fieldName)) {
                    List<DocumentWarning> warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedSentimentResponseDocumentsItem.setWarnings(warnings);
                } else if ("sentiment".equals(fieldName)) {
                    deserializedSentimentResponseDocumentsItem
                        .setSentiment(DocumentSentimentValue.fromString(reader.getString()));
                } else if ("confidenceScores".equals(fieldName)) {
                    deserializedSentimentResponseDocumentsItem
                        .setConfidenceScores(SentimentConfidenceScorePerLabel.fromJson(reader));
                } else if ("sentences".equals(fieldName)) {
                    List<SentenceSentiment> sentences
                        = reader.readArray(reader1 -> SentenceSentiment.fromJson(reader1));
                    deserializedSentimentResponseDocumentsItem.setSentences(sentences);
                } else if ("statistics".equals(fieldName)) {
                    deserializedSentimentResponseDocumentsItem.setStatistics(DocumentStatistics.fromJson(reader));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSentimentResponseDocumentsItem;
        });
    }
}
