// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the confidence scores across all sentiment classes: positive and negative.
 */
@Fluent
public final class TargetConfidenceScoreLabel implements JsonSerializable<TargetConfidenceScoreLabel> {
    /*
     * Confidence score for positive sentiment
     */
    private double positive;

    /*
     * Confidence score for negative sentiment
     */
    private double negative;

    /**
     * Creates an instance of TargetConfidenceScoreLabel class.
     */
    public TargetConfidenceScoreLabel() {
    }

    /**
     * Get the positive property: Confidence score for positive sentiment.
     * 
     * @return the positive value.
     */
    public double getPositive() {
        return this.positive;
    }

    /**
     * Set the positive property: Confidence score for positive sentiment.
     * 
     * @param positive the positive value to set.
     * @return the TargetConfidenceScoreLabel object itself.
     */
    public TargetConfidenceScoreLabel setPositive(double positive) {
        this.positive = positive;
        return this;
    }

    /**
     * Get the negative property: Confidence score for negative sentiment.
     * 
     * @return the negative value.
     */
    public double getNegative() {
        return this.negative;
    }

    /**
     * Set the negative property: Confidence score for negative sentiment.
     * 
     * @param negative the negative value to set.
     * @return the TargetConfidenceScoreLabel object itself.
     */
    public TargetConfidenceScoreLabel setNegative(double negative) {
        this.negative = negative;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("positive", this.positive);
        jsonWriter.writeDoubleField("negative", this.negative);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TargetConfidenceScoreLabel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TargetConfidenceScoreLabel if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TargetConfidenceScoreLabel.
     */
    public static TargetConfidenceScoreLabel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TargetConfidenceScoreLabel deserializedTargetConfidenceScoreLabel = new TargetConfidenceScoreLabel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("positive".equals(fieldName)) {
                    deserializedTargetConfidenceScoreLabel.positive = reader.getDouble();
                } else if ("negative".equals(fieldName)) {
                    deserializedTargetConfidenceScoreLabel.negative = reader.getDouble();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTargetConfidenceScoreLabel;
        });
    }
}
