// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Base task object.
 */
@Fluent
public class TaskIdentifier implements JsonSerializable<TaskIdentifier> {
    /*
     * The taskName property.
     */
    private String taskName;

    /**
     * Creates an instance of TaskIdentifier class.
     */
    public TaskIdentifier() {
    }

    /**
     * Get the taskName property: The taskName property.
     * 
     * @return the taskName value.
     */
    public String getTaskName() {
        return this.taskName;
    }

    /**
     * Set the taskName property: The taskName property.
     * 
     * @param taskName the taskName value to set.
     * @return the TaskIdentifier object itself.
     */
    public TaskIdentifier setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("taskName", this.taskName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TaskIdentifier from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TaskIdentifier if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TaskIdentifier.
     */
    public static TaskIdentifier fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TaskIdentifier deserializedTaskIdentifier = new TaskIdentifier();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("taskName".equals(fieldName)) {
                    deserializedTaskIdentifier.taskName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTaskIdentifier;
        });
    }
}
