// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The TasksState model.
 */
@Fluent
public class TasksState implements JsonSerializable<TasksState> {
    /*
     * The tasks property.
     */
    private TasksStateTasks tasks;

    /**
     * Creates an instance of TasksState class.
     */
    public TasksState() {
    }

    /**
     * Get the tasks property: The tasks property.
     * 
     * @return the tasks value.
     */
    public TasksStateTasks getTasks() {
        return this.tasks;
    }

    /**
     * Set the tasks property: The tasks property.
     * 
     * @param tasks the tasks value to set.
     * @return the TasksState object itself.
     */
    public TasksState setTasks(TasksStateTasks tasks) {
        this.tasks = tasks;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("tasks", this.tasks);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TasksState from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TasksState if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TasksState.
     */
    public static TasksState fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TasksState deserializedTasksState = new TasksState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tasks".equals(fieldName)) {
                    deserializedTasksState.tasks = TasksStateTasks.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTasksState;
        });
    }
}
