// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.ExpandableStringEnum;

import java.util.Collection;

/**
 * Defines values for {@code WarningCode}.
 */
@Immutable
public final class WarningCode extends ExpandableStringEnum<WarningCode> {
    /**
     * Static value LongWordsInDocument for {@code WarningCode}.
     */
    public static final WarningCode LONG_WORDS_IN_DOCUMENT = fromString("LongWordsInDocument");

    /**
     * Static value DocumentTruncated for {@code WarningCode}.
     */
    public static final WarningCode DOCUMENT_TRUNCATED = fromString("DocumentTruncated");

    /**
     * Creates a new instance of {@code WarningCode} value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public WarningCode() {
    }

    /**
     * Creates or finds a {@code WarningCode} from its string representation.
     *
     * @param name A name to look for.
     * @return The corresponding {@code WarningCode}.
     */
    public static WarningCode fromString(String name) {
        return fromString(name, WarningCode.class);
    }

    /**
     * All known WarningCode values.
     *
     * @return known WarningCode values.
     */
    public static Collection<WarningCode> values() {
        return values(WarningCode.class);
    }
}
