/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextEntityLinkingInput;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingTaskParameters;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.models.LinkedEntityCollection;
import com.azure.ai.textanalytics.models.RecognizeLinkedEntitiesResult;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.RecognizeLinkedEntitiesResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import reactor.core.publisher.Mono;

class RecognizeLinkedEntityUtilClient {
    private static final ClientLogger LOGGER = new ClientLogger(RecognizeLinkedEntityUtilClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final MicrosoftCognitiveLanguageServiceTextAnalysisImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;

    RecognizeLinkedEntityUtilClient(TextAnalyticsClientImpl legacyService, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = legacyService;
        this.service = null;
        this.serviceVersion = serviceVersion;
    }

    RecognizeLinkedEntityUtilClient(MicrosoftCognitiveLanguageServiceTextAnalysisImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = null;
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    Mono<LinkedEntityCollection> recognizeLinkedEntities(String document, String language) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            TextDocumentInput textDocumentInput = new TextDocumentInput("0", document);
            textDocumentInput.setLanguage(language);
            return this.recognizeLinkedEntitiesBatch(Collections.singletonList(textDocumentInput), null).map(resultCollectionResponse -> {
                LinkedEntityCollection linkedEntityCollection = null;
                Iterator iterator = ((RecognizeLinkedEntitiesResultCollection)((Object)((Object)resultCollectionResponse.getValue()))).iterator();
                while (iterator.hasNext()) {
                    RecognizeLinkedEntitiesResult entitiesResult = (RecognizeLinkedEntitiesResult)iterator.next();
                    if (entitiesResult.isError()) {
                        throw LOGGER.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(entitiesResult.getError())));
                    }
                    linkedEntityCollection = new LinkedEntityCollection(entitiesResult.getEntities(), entitiesResult.getEntities().getWarnings());
                }
                return linkedEntityCollection;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<RecognizeLinkedEntitiesResultCollection>> recognizeLinkedEntitiesBatch(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        try {
            return FluxUtil.withContext(context -> this.getRecognizedLinkedEntitiesResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<Response<RecognizeLinkedEntitiesResultCollection>> getRecognizedLinkedEntitiesResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        this.throwIfCallingNotAvailableFeatureInOptions(options);
        Utility.inputDocumentsValidation(documents);
        options = options == null ? new TextAnalyticsRequestOptions() : options;
        Context finalContext = Utility.getNotNullContext(context);
        StringIndexType finalStringIndexType = StringIndexType.UTF16CODE_UNIT;
        String finalModelVersion = options.getModelVersion();
        boolean finalLoggingOptOut = options.isServiceLogsDisabled();
        boolean finalIncludeStatistics = options.isIncludeStatistics();
        if (this.service != null) {
            return this.service.analyzeTextWithResponseAsync(new AnalyzeTextEntityLinkingInput().setParameters(new EntityLinkingTaskParameters().setStringIndexType(finalStringIndexType).setModelVersion(finalModelVersion).setLoggingOptOut(finalLoggingOptOut)).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))), finalIncludeStatistics, finalContext).doOnSubscribe(ignoredValue -> LOGGER.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> LOGGER.info("Recognized linked entities for a batch of documents - {}", new Object[]{response.getValue()})).doOnError(error -> LOGGER.warning("Failed to recognize linked entities - {}", new Object[]{error})).map(Utility::toRecognizeLinkedEntitiesResultCollectionResponseLanguageApi).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        return this.legacyService.entitiesLinkingWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), finalModelVersion, finalIncludeStatistics, finalLoggingOptOut, finalStringIndexType, finalContext).doOnSubscribe(ignoredValue -> LOGGER.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> LOGGER.info("Recognized linked entities for a batch of documents - {}", new Object[]{response.getValue()})).doOnError(error -> LOGGER.warning("Failed to recognize linked entities - {}", new Object[]{error})).map(Utility::toRecognizeLinkedEntitiesResultCollectionResponseLegacyApi).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }

    Response<RecognizeLinkedEntitiesResultCollection> getRecognizedLinkedEntitiesResponseSync(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        this.throwIfCallingNotAvailableFeatureInOptions(options);
        Utility.inputDocumentsValidation(documents);
        options = options == null ? new TextAnalyticsRequestOptions() : options;
        Context finalContext = Utility.enableSyncRestProxy(Utility.getNotNullContext(context));
        StringIndexType finalStringIndexType = StringIndexType.UTF16CODE_UNIT;
        String finalModelVersion = options.getModelVersion();
        boolean finalLoggingOptOut = options.isServiceLogsDisabled();
        boolean finalIncludeStatistics = options.isIncludeStatistics();
        try {
            return this.service != null ? Utility.toRecognizeLinkedEntitiesResultCollectionResponseLanguageApi(this.service.analyzeTextWithResponse(new AnalyzeTextEntityLinkingInput().setParameters(new EntityLinkingTaskParameters().setStringIndexType(finalStringIndexType).setModelVersion(finalModelVersion).setLoggingOptOut(finalLoggingOptOut)).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))), finalIncludeStatistics, finalContext)) : Utility.toRecognizeLinkedEntitiesResultCollectionResponseLegacyApi(this.legacyService.entitiesLinkingWithResponseSync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), finalModelVersion, finalIncludeStatistics, finalLoggingOptOut, finalStringIndexType, finalContext));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
        }
    }

    private void throwIfCallingNotAvailableFeatureInOptions(TextAnalyticsRequestOptions options) {
        if (options != null && options.isServiceLogsDisabled()) {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0), Utility.getUnsupportedServiceApiVersionMessage("TextAnalyticsRequestOptions.disableServiceLogs", this.serviceVersion, TextAnalyticsServiceVersion.V3_1));
        }
    }
}

