/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AbstractiveSummary;
import com.azure.ai.textanalytics.implementation.models.DocumentResult;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AbstractiveSummaryDocumentResult
extends DocumentResult {
    private List<AbstractiveSummary> summaries;

    public List<AbstractiveSummary> getSummaries() {
        return this.summaries;
    }

    public AbstractiveSummaryDocumentResult setSummaries(List<AbstractiveSummary> summaries) {
        this.summaries = summaries;
        return this;
    }

    @Override
    public AbstractiveSummaryDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public AbstractiveSummaryDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    @Override
    public AbstractiveSummaryDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("summaries", this.summaries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AbstractiveSummaryDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return (AbstractiveSummaryDocumentResult)jsonReader.readObject(reader -> {
            AbstractiveSummaryDocumentResult deserializedAbstractiveSummaryDocumentResult = new AbstractiveSummaryDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAbstractiveSummaryDocumentResult.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedAbstractiveSummaryDocumentResult.setWarnings(warnings);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedAbstractiveSummaryDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                if ("summaries".equals(fieldName)) {
                    List summaries;
                    deserializedAbstractiveSummaryDocumentResult.summaries = summaries = reader.readArray(reader1 -> AbstractiveSummary.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAbstractiveSummaryDocumentResult;
        });
    }
}

