/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.PreBuiltTaskParameters;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EntityLinkingTaskParameters
extends PreBuiltTaskParameters {
    private StringIndexType stringIndexType;

    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    public EntityLinkingTaskParameters setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    @Override
    public EntityLinkingTaskParameters setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    @Override
    public EntityLinkingTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("loggingOptOut", this.isLoggingOptOut());
        jsonWriter.writeStringField("modelVersion", this.getModelVersion());
        jsonWriter.writeStringField("stringIndexType", this.stringIndexType == null ? null : this.stringIndexType.toString());
        return jsonWriter.writeEndObject();
    }

    public static EntityLinkingTaskParameters fromJson(JsonReader jsonReader) throws IOException {
        return (EntityLinkingTaskParameters)jsonReader.readObject(reader -> {
            EntityLinkingTaskParameters deserializedEntityLinkingTaskParameters = new EntityLinkingTaskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loggingOptOut".equals(fieldName)) {
                    deserializedEntityLinkingTaskParameters.setLoggingOptOut((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    deserializedEntityLinkingTaskParameters.setModelVersion(reader.getString());
                    continue;
                }
                if ("stringIndexType".equals(fieldName)) {
                    deserializedEntityLinkingTaskParameters.stringIndexType = StringIndexType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntityLinkingTaskParameters;
        });
    }
}

