/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseResultDocumentsItem;
import com.azure.ai.textanalytics.implementation.models.PreBuiltResult;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class KeyPhraseResult
extends PreBuiltResult {
    private List<KeyPhraseResultDocumentsItem> documents;

    public List<KeyPhraseResultDocumentsItem> getDocuments() {
        return this.documents;
    }

    public KeyPhraseResult setDocuments(List<KeyPhraseResultDocumentsItem> documents) {
        this.documents = documents;
        return this;
    }

    @Override
    public KeyPhraseResult setErrors(List<DocumentError> errors) {
        super.setErrors(errors);
        return this;
    }

    @Override
    public KeyPhraseResult setStatistics(RequestStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public KeyPhraseResult setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", this.getErrors(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("modelVersion", this.getModelVersion());
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static KeyPhraseResult fromJson(JsonReader jsonReader) throws IOException {
        return (KeyPhraseResult)jsonReader.readObject(reader -> {
            KeyPhraseResult deserializedKeyPhraseResult = new KeyPhraseResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    deserializedKeyPhraseResult.setErrors(errors);
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    deserializedKeyPhraseResult.setModelVersion(reader.getString());
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedKeyPhraseResult.setStatistics(RequestStatistics.fromJson(reader));
                    continue;
                }
                if ("documents".equals(fieldName)) {
                    List documents;
                    deserializedKeyPhraseResult.documents = documents = reader.readArray(reader1 -> KeyPhraseResultDocumentsItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyPhraseResult;
        });
    }
}

