/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTaskKind;
import com.azure.ai.textanalytics.implementation.models.PiiTaskParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PiiLROTask
extends AnalyzeTextLROTask {
    private AnalyzeTextLROTaskKind kind = AnalyzeTextLROTaskKind.PII_ENTITY_RECOGNITION;
    private PiiTaskParameters parameters;

    @Override
    public AnalyzeTextLROTaskKind getKind() {
        return this.kind;
    }

    public PiiTaskParameters getParameters() {
        return this.parameters;
    }

    public PiiLROTask setParameters(PiiTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public PiiLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static PiiLROTask fromJson(JsonReader jsonReader) throws IOException {
        return (PiiLROTask)jsonReader.readObject(reader -> {
            PiiLROTask deserializedPiiLROTask = new PiiLROTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("taskName".equals(fieldName)) {
                    deserializedPiiLROTask.setTaskName(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedPiiLROTask.kind = AnalyzeTextLROTaskKind.fromString(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedPiiLROTask.parameters = PiiTaskParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPiiLROTask;
        });
    }
}

