/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.PiiResultDocumentsItem;
import com.azure.ai.textanalytics.implementation.models.PreBuiltResult;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class PiiResult
extends PreBuiltResult {
    private List<PiiResultDocumentsItem> documents;

    public List<PiiResultDocumentsItem> getDocuments() {
        return this.documents;
    }

    public PiiResult setDocuments(List<PiiResultDocumentsItem> documents) {
        this.documents = documents;
        return this;
    }

    @Override
    public PiiResult setErrors(List<DocumentError> errors) {
        super.setErrors(errors);
        return this;
    }

    @Override
    public PiiResult setStatistics(RequestStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public PiiResult setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", this.getErrors(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("modelVersion", this.getModelVersion());
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PiiResult fromJson(JsonReader jsonReader) throws IOException {
        return (PiiResult)jsonReader.readObject(reader -> {
            PiiResult deserializedPiiResult = new PiiResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    deserializedPiiResult.setErrors(errors);
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    deserializedPiiResult.setModelVersion(reader.getString());
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedPiiResult.setStatistics(RequestStatistics.fromJson(reader));
                    continue;
                }
                if ("documents".equals(fieldName)) {
                    List documents;
                    deserializedPiiResult.documents = documents = reader.readArray(reader1 -> PiiResultDocumentsItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPiiResult;
        });
    }
}

