/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.models.TextAnalyticsErrorCode;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TextAnalyticsError
implements JsonSerializable<TextAnalyticsError> {
    private final TextAnalyticsErrorCode errorCode;
    private final String message;
    private final String target;

    public TextAnalyticsError(TextAnalyticsErrorCode errorCode, String message, String target) {
        this.errorCode = errorCode;
        this.message = message;
        this.target = target;
    }

    public TextAnalyticsErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTarget() {
        return this.target;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("errorCode", this.errorCode == null ? null : this.errorCode.toString());
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        return jsonWriter.writeEndObject();
    }

    public static TextAnalyticsError fromJson(JsonReader jsonReader) throws IOException {
        return (TextAnalyticsError)jsonReader.readObject(reader -> {
            TextAnalyticsErrorCode errorCode = null;
            String message = null;
            String target = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errorCode".equals(fieldName)) {
                    errorCode = TextAnalyticsErrorCode.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    target = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new TextAnalyticsError(errorCode, message, target);
        });
    }
}

