// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An object representing the summarization results of each document.
 */
@Fluent
public class AbstractiveSummarizationResultBase implements JsonSerializable<AbstractiveSummarizationResultBase> {
    /*
     * Response by document
     */
    private List<AbstractiveSummaryDocumentResult> documents;

    /**
     * Creates an instance of AbstractiveSummarizationResultBase class.
     */
    public AbstractiveSummarizationResultBase() {
    }

    /**
     * Get the documents property: Response by document.
     * 
     * @return the documents value.
     */
    public List<AbstractiveSummaryDocumentResult> getDocuments() {
        return this.documents;
    }

    /**
     * Set the documents property: Response by document.
     * 
     * @param documents the documents value to set.
     * @return the AbstractiveSummarizationResultBase object itself.
     */
    public AbstractiveSummarizationResultBase setDocuments(List<AbstractiveSummaryDocumentResult> documents) {
        this.documents = documents;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AbstractiveSummarizationResultBase from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AbstractiveSummarizationResultBase if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AbstractiveSummarizationResultBase.
     */
    public static AbstractiveSummarizationResultBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AbstractiveSummarizationResultBase deserializedAbstractiveSummarizationResultBase
                = new AbstractiveSummarizationResultBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("documents".equals(fieldName)) {
                    List<AbstractiveSummaryDocumentResult> documents
                        = reader.readArray(reader1 -> AbstractiveSummaryDocumentResult.fromJson(reader1));
                    deserializedAbstractiveSummarizationResultBase.documents = documents;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAbstractiveSummarizationResultBase;
        });
    }
}
