// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * The AnalyzeTextJobState model.
 */
@Fluent
public final class AnalyzeTextJobState extends JobState {
    /*
     * The tasks property.
     */
    private TasksStateTasks tasks;

    /*
     * if showStats=true was specified in the request this field will contain information about the request payload.
     */
    private RequestStatistics statistics;

    /**
     * Creates an instance of AnalyzeTextJobState class.
     */
    public AnalyzeTextJobState() {
    }

    /**
     * Get the tasks property: The tasks property.
     * 
     * @return the tasks value.
     */
    public TasksStateTasks getTasks() {
        return this.tasks;
    }

    /**
     * Set the tasks property: The tasks property.
     * 
     * @param tasks the tasks value to set.
     * @return the AnalyzeTextJobState object itself.
     */
    public AnalyzeTextJobState setTasks(TasksStateTasks tasks) {
        this.tasks = tasks;
        return this;
    }

    /**
     * Get the statistics property: if showStats=true was specified in the request this field will contain information
     * about the request payload.
     * 
     * @return the statistics value.
     */
    public RequestStatistics getStatistics() {
        return this.statistics;
    }

    /**
     * Set the statistics property: if showStats=true was specified in the request this field will contain information
     * about the request payload.
     * 
     * @param statistics the statistics value to set.
     * @return the AnalyzeTextJobState object itself.
     */
    public AnalyzeTextJobState setStatistics(RequestStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AnalyzeTextJobState setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AnalyzeTextJobState setCreatedDateTime(OffsetDateTime createdDateTime) {
        super.setCreatedDateTime(createdDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AnalyzeTextJobState setExpirationDateTime(OffsetDateTime expirationDateTime) {
        super.setExpirationDateTime(expirationDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AnalyzeTextJobState setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AnalyzeTextJobState setLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        super.setLastUpdatedDateTime(lastUpdatedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AnalyzeTextJobState setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AnalyzeTextJobState setErrors(List<Error> errors) {
        super.setErrors(errors);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AnalyzeTextJobState setNextLink(String nextLink) {
        super.setNextLink(nextLink);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDateTime",
            getCreatedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getCreatedDateTime()));
        jsonWriter.writeStringField("jobId", getJobId());
        jsonWriter.writeStringField("lastUpdatedDateTime",
            getLastUpdatedDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getLastUpdatedDateTime()));
        jsonWriter.writeStringField("status", getStatus() == null ? null : getStatus().toString());
        jsonWriter.writeStringField("displayName", getDisplayName());
        jsonWriter.writeStringField("expirationDateTime",
            getExpirationDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getExpirationDateTime()));
        jsonWriter.writeArrayField("errors", getErrors(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", getNextLink());
        jsonWriter.writeJsonField("tasks", this.tasks);
        jsonWriter.writeJsonField("statistics", this.statistics);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnalyzeTextJobState from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnalyzeTextJobState if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AnalyzeTextJobState.
     */
    public static AnalyzeTextJobState fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AnalyzeTextJobState deserializedAnalyzeTextJobState = new AnalyzeTextJobState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("createdDateTime".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setCreatedDateTime(
                        reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                } else if ("jobId".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setJobId(reader.getString());
                } else if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setLastUpdatedDateTime(
                        reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                } else if ("status".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setStatus(State.fromString(reader.getString()));
                } else if ("displayName".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setDisplayName(reader.getString());
                } else if ("expirationDateTime".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setExpirationDateTime(
                        reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                } else if ("errors".equals(fieldName)) {
                    List<Error> errors = reader.readArray(reader1 -> Error.fromJson(reader1));
                    deserializedAnalyzeTextJobState.setErrors(errors);
                } else if ("nextLink".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setNextLink(reader.getString());
                } else if ("tasks".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.tasks = TasksStateTasks.fromJson(reader);
                } else if ("statistics".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.statistics = RequestStatistics.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAnalyzeTextJobState;
        });
    }
}
