// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;

/**
 * The AnalyzeTextsSubmitJobHeaders model.
 */
@Fluent
public final class AnalyzeTextsSubmitJobHeaders {
    /*
     * The Operation-Location property.
     */
    private String operationLocation;

    private static final HttpHeaderName OPERATION_LOCATION = HttpHeaderName.fromString("Operation-Location");

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of AnalyzeTextsSubmitJobHeaders class.
     * 
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public AnalyzeTextsSubmitJobHeaders(HttpHeaders rawHeaders) {
        this.operationLocation = rawHeaders.getValue(OPERATION_LOCATION);
    }

    /**
     * Get the operationLocation property: The Operation-Location property.
     * 
     * @return the operationLocation value.
     */
    public String getOperationLocation() {
        return this.operationLocation;
    }

    /**
     * Set the operationLocation property: The Operation-Location property.
     * 
     * @param operationLocation the operationLocation value to set.
     * @return the AnalyzeTextsSubmitJobHeaders object itself.
     */
    public AnalyzeTextsSubmitJobHeaders setOperationLocation(String operationLocation) {
        this.operationLocation = operationLocation;
        return this;
    }
}
