// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The DetectedLanguage model.
 */
@Fluent
public final class DetectedLanguage implements JsonSerializable<DetectedLanguage> {
    /*
     * Long name of a detected language (e.g. English, French).
     */
    private String name;

    /*
     * A two letter representation of the detected language according to the ISO 639-1 standard (e.g. en, fr).
     */
    private String iso6391Name;

    /*
     * A confidence score between 0 and 1. Scores close to 1 indicate 100% certainty that the identified language is true.
     */
    private double confidenceScore;

    /**
     * Creates an instance of DetectedLanguage class.
     */
    public DetectedLanguage() {
    }

    /**
     * Get the name property: Long name of a detected language (e.g. English, French).
     * 
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: Long name of a detected language (e.g. English, French).
     * 
     * @param name the name value to set.
     * @return the DetectedLanguage object itself.
     */
    public DetectedLanguage setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the iso6391Name property: A two letter representation of the detected language according to the ISO 639-1
     * standard (e.g. en, fr).
     * 
     * @return the iso6391Name value.
     */
    public String getIso6391Name() {
        return this.iso6391Name;
    }

    /**
     * Set the iso6391Name property: A two letter representation of the detected language according to the ISO 639-1
     * standard (e.g. en, fr).
     * 
     * @param iso6391Name the iso6391Name value to set.
     * @return the DetectedLanguage object itself.
     */
    public DetectedLanguage setIso6391Name(String iso6391Name) {
        this.iso6391Name = iso6391Name;
        return this;
    }

    /**
     * Get the confidenceScore property: A confidence score between 0 and 1. Scores close to 1 indicate 100% certainty
     * that the identified language is true.
     * 
     * @return the confidenceScore value.
     */
    public double getConfidenceScore() {
        return this.confidenceScore;
    }

    /**
     * Set the confidenceScore property: A confidence score between 0 and 1. Scores close to 1 indicate 100% certainty
     * that the identified language is true.
     * 
     * @param confidenceScore the confidenceScore value to set.
     * @return the DetectedLanguage object itself.
     */
    public DetectedLanguage setConfidenceScore(double confidenceScore) {
        this.confidenceScore = confidenceScore;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("iso6391Name", this.iso6391Name);
        jsonWriter.writeDoubleField("confidenceScore", this.confidenceScore);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DetectedLanguage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DetectedLanguage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DetectedLanguage.
     */
    public static DetectedLanguage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DetectedLanguage deserializedDetectedLanguage = new DetectedLanguage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDetectedLanguage.name = reader.getString();
                } else if ("iso6391Name".equals(fieldName)) {
                    deserializedDetectedLanguage.iso6391Name = reader.getString();
                } else if ("confidenceScore".equals(fieldName)) {
                    deserializedDetectedLanguage.confidenceScore = reader.getDouble();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDetectedLanguage;
        });
    }
}
