// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The EntitiesResult model.
 */
@Fluent
public final class EntitiesResult extends PreBuiltResult {
    /*
     * Response by document
     */
    private List<EntitiesResultDocumentsItem> documents;

    /**
     * Creates an instance of EntitiesResult class.
     */
    public EntitiesResult() {
    }

    /**
     * Get the documents property: Response by document.
     * 
     * @return the documents value.
     */
    public List<EntitiesResultDocumentsItem> getDocuments() {
        return this.documents;
    }

    /**
     * Set the documents property: Response by document.
     * 
     * @param documents the documents value to set.
     * @return the EntitiesResult object itself.
     */
    public EntitiesResult setDocuments(List<EntitiesResultDocumentsItem> documents) {
        this.documents = documents;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EntitiesResult setErrors(List<DocumentError> errors) {
        super.setErrors(errors);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EntitiesResult setStatistics(RequestStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EntitiesResult setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", getErrors(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("modelVersion", getModelVersion());
        jsonWriter.writeJsonField("statistics", getStatistics());
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EntitiesResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EntitiesResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EntitiesResult.
     */
    public static EntitiesResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EntitiesResult deserializedEntitiesResult = new EntitiesResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("errors".equals(fieldName)) {
                    List<DocumentError> errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    deserializedEntitiesResult.setErrors(errors);
                } else if ("modelVersion".equals(fieldName)) {
                    deserializedEntitiesResult.setModelVersion(reader.getString());
                } else if ("statistics".equals(fieldName)) {
                    deserializedEntitiesResult.setStatistics(RequestStatistics.fromJson(reader));
                } else if ("documents".equals(fieldName)) {
                    List<EntitiesResultDocumentsItem> documents
                        = reader.readArray(reader1 -> EntitiesResultDocumentsItem.fromJson(reader1));
                    deserializedEntitiesResult.documents = documents;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEntitiesResult;
        });
    }
}
