// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The EntityLinkingResult model.
 */
@Fluent
public final class EntityLinkingResult extends PreBuiltResult {
    /*
     * Response by document
     */
    private List<EntityLinkingResultDocumentsItem> documents;

    /**
     * Creates an instance of EntityLinkingResult class.
     */
    public EntityLinkingResult() {
    }

    /**
     * Get the documents property: Response by document.
     * 
     * @return the documents value.
     */
    public List<EntityLinkingResultDocumentsItem> getDocuments() {
        return this.documents;
    }

    /**
     * Set the documents property: Response by document.
     * 
     * @param documents the documents value to set.
     * @return the EntityLinkingResult object itself.
     */
    public EntityLinkingResult setDocuments(List<EntityLinkingResultDocumentsItem> documents) {
        this.documents = documents;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EntityLinkingResult setErrors(List<DocumentError> errors) {
        super.setErrors(errors);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EntityLinkingResult setStatistics(RequestStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EntityLinkingResult setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", getErrors(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("modelVersion", getModelVersion());
        jsonWriter.writeJsonField("statistics", getStatistics());
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EntityLinkingResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EntityLinkingResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EntityLinkingResult.
     */
    public static EntityLinkingResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EntityLinkingResult deserializedEntityLinkingResult = new EntityLinkingResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("errors".equals(fieldName)) {
                    List<DocumentError> errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    deserializedEntityLinkingResult.setErrors(errors);
                } else if ("modelVersion".equals(fieldName)) {
                    deserializedEntityLinkingResult.setModelVersion(reader.getString());
                } else if ("statistics".equals(fieldName)) {
                    deserializedEntityLinkingResult.setStatistics(RequestStatistics.fromJson(reader));
                } else if ("documents".equals(fieldName)) {
                    List<EntityLinkingResultDocumentsItem> documents
                        = reader.readArray(reader1 -> EntityLinkingResultDocumentsItem.fromJson(reader1));
                    deserializedEntityLinkingResult.documents = documents;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEntityLinkingResult;
        });
    }
}
