// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * The error object.
 */
@Fluent
public final class Error implements JsonSerializable<Error> {
    /*
     * One of a server-defined set of error codes.
     */
    private ErrorCode code;

    /*
     * A human-readable representation of the error.
     */
    private String message;

    /*
     * The target of the error.
     */
    private String target;

    /*
     * An array of details about specific errors that led to this reported error.
     */
    private List<Error> details;

    /*
     * An object containing more specific information than the current object about the error.
     */
    private InnerErrorModel innererror;

    /*
     * The error object.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of Error class.
     */
    public Error() {
    }

    /**
     * Get the code property: One of a server-defined set of error codes.
     * 
     * @return the code value.
     */
    public ErrorCode getCode() {
        return this.code;
    }

    /**
     * Set the code property: One of a server-defined set of error codes.
     * 
     * @param code the code value to set.
     * @return the Error object itself.
     */
    public Error setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: A human-readable representation of the error.
     * 
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Set the message property: A human-readable representation of the error.
     * 
     * @param message the message value to set.
     * @return the Error object itself.
     */
    public Error setMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the target property: The target of the error.
     * 
     * @return the target value.
     */
    public String getTarget() {
        return this.target;
    }

    /**
     * Set the target property: The target of the error.
     * 
     * @param target the target value to set.
     * @return the Error object itself.
     */
    public Error setTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the details property: An array of details about specific errors that led to this reported error.
     * 
     * @return the details value.
     */
    public List<Error> getDetails() {
        return this.details;
    }

    /**
     * Set the details property: An array of details about specific errors that led to this reported error.
     * 
     * @param details the details value to set.
     * @return the Error object itself.
     */
    public Error setDetails(List<Error> details) {
        this.details = details;
        return this;
    }

    /**
     * Get the innererror property: An object containing more specific information than the current object about the
     * error.
     * 
     * @return the innererror value.
     */
    public InnerErrorModel getInnererror() {
        return this.innererror;
    }

    /**
     * Set the innererror property: An object containing more specific information than the current object about the
     * error.
     * 
     * @param innererror the innererror value to set.
     * @return the Error object itself.
     */
    public Error setInnererror(InnerErrorModel innererror) {
        this.innererror = innererror;
        return this;
    }

    /**
     * Get the additionalProperties property: The error object.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: The error object.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the Error object itself.
     */
    public Error setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code == null ? null : this.code.toString());
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("innererror", this.innererror);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Error from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Error if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Error.
     */
    public static Error fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Error deserializedError = new Error();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedError.code = ErrorCode.fromString(reader.getString());
                } else if ("message".equals(fieldName)) {
                    deserializedError.message = reader.getString();
                } else if ("target".equals(fieldName)) {
                    deserializedError.target = reader.getString();
                } else if ("details".equals(fieldName)) {
                    List<Error> details = reader.readArray(reader1 -> Error.fromJson(reader1));
                    deserializedError.details = details;
                } else if ("innererror".equals(fieldName)) {
                    deserializedError.innererror = InnerErrorModel.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedError.additionalProperties = additionalProperties;

            return deserializedError;
        });
    }
}
