// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The KeyPhraseTaskResult model.
 */
@Fluent
public final class KeyPhraseTaskResult extends AnalyzeTextTaskResult {
    /*
     * Enumeration of supported Text Analysis task results.
     */
    private AnalyzeTextTaskResultsKind kind = AnalyzeTextTaskResultsKind.KEY_PHRASE_EXTRACTION_RESULTS;

    /*
     * The results property.
     */
    private KeyPhraseResult results;

    /**
     * Creates an instance of KeyPhraseTaskResult class.
     */
    public KeyPhraseTaskResult() {
    }

    /**
     * Get the kind property: Enumeration of supported Text Analysis task results.
     * 
     * @return the kind value.
     */
    @Override
    public AnalyzeTextTaskResultsKind getKind() {
        return this.kind;
    }

    /**
     * Get the results property: The results property.
     * 
     * @return the results value.
     */
    public KeyPhraseResult getResults() {
        return this.results;
    }

    /**
     * Set the results property: The results property.
     * 
     * @param results the results value to set.
     * @return the KeyPhraseTaskResult object itself.
     */
    public KeyPhraseTaskResult setResults(KeyPhraseResult results) {
        this.results = results;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("results", this.results);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyPhraseTaskResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyPhraseTaskResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyPhraseTaskResult.
     */
    public static KeyPhraseTaskResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyPhraseTaskResult deserializedKeyPhraseTaskResult = new KeyPhraseTaskResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("results".equals(fieldName)) {
                    deserializedKeyPhraseTaskResult.results = KeyPhraseResult.fromJson(reader);
                } else if ("kind".equals(fieldName)) {
                    deserializedKeyPhraseTaskResult.kind = AnalyzeTextTaskResultsKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyPhraseTaskResult;
        });
    }
}
