// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The LanguageDetectionDocumentResult model.
 */
@Fluent
public final class LanguageDetectionDocumentResult extends DocumentResult {
    /*
     * Detected Language.
     */
    private DetectedLanguage detectedLanguage;

    /**
     * Creates an instance of LanguageDetectionDocumentResult class.
     */
    public LanguageDetectionDocumentResult() {
    }

    /**
     * Get the detectedLanguage property: Detected Language.
     * 
     * @return the detectedLanguage value.
     */
    public DetectedLanguage getDetectedLanguage() {
        return this.detectedLanguage;
    }

    /**
     * Set the detectedLanguage property: Detected Language.
     * 
     * @param detectedLanguage the detectedLanguage value to set.
     * @return the LanguageDetectionDocumentResult object itself.
     */
    public LanguageDetectionDocumentResult setDetectedLanguage(DetectedLanguage detectedLanguage) {
        this.detectedLanguage = detectedLanguage;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LanguageDetectionDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LanguageDetectionDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LanguageDetectionDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeArrayField("warnings", getWarnings(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("statistics", getStatistics());
        jsonWriter.writeJsonField("detectedLanguage", this.detectedLanguage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LanguageDetectionDocumentResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LanguageDetectionDocumentResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LanguageDetectionDocumentResult.
     */
    public static LanguageDetectionDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LanguageDetectionDocumentResult deserializedLanguageDetectionDocumentResult
                = new LanguageDetectionDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedLanguageDetectionDocumentResult.setId(reader.getString());
                } else if ("warnings".equals(fieldName)) {
                    List<DocumentWarning> warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedLanguageDetectionDocumentResult.setWarnings(warnings);
                } else if ("statistics".equals(fieldName)) {
                    deserializedLanguageDetectionDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                } else if ("detectedLanguage".equals(fieldName)) {
                    deserializedLanguageDetectionDocumentResult.detectedLanguage = DetectedLanguage.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLanguageDetectionDocumentResult;
        });
    }
}
