// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The LinkedEntity model.
 */
@Fluent
public final class LinkedEntity implements JsonSerializable<LinkedEntity> {
    /*
     * Entity Linking formal name.
     */
    private String name;

    /*
     * List of instances this entity appears in the text.
     */
    private List<Match> matches;

    /*
     * Language used in the data source.
     */
    private String language;

    /*
     * Unique identifier of the recognized entity from the data source.
     */
    private String id;

    /*
     * URL for the entity's page from the data source.
     */
    private String url;

    /*
     * Data source used to extract entity linking, such as Wiki/Bing etc.
     */
    private String dataSource;

    /*
     * Bing Entity Search API unique identifier of the recognized entity.
     */
    private String bingId;

    /**
     * Creates an instance of LinkedEntity class.
     */
    public LinkedEntity() {
    }

    /**
     * Get the name property: Entity Linking formal name.
     * 
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: Entity Linking formal name.
     * 
     * @param name the name value to set.
     * @return the LinkedEntity object itself.
     */
    public LinkedEntity setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the matches property: List of instances this entity appears in the text.
     * 
     * @return the matches value.
     */
    public List<Match> getMatches() {
        return this.matches;
    }

    /**
     * Set the matches property: List of instances this entity appears in the text.
     * 
     * @param matches the matches value to set.
     * @return the LinkedEntity object itself.
     */
    public LinkedEntity setMatches(List<Match> matches) {
        this.matches = matches;
        return this;
    }

    /**
     * Get the language property: Language used in the data source.
     * 
     * @return the language value.
     */
    public String getLanguage() {
        return this.language;
    }

    /**
     * Set the language property: Language used in the data source.
     * 
     * @param language the language value to set.
     * @return the LinkedEntity object itself.
     */
    public LinkedEntity setLanguage(String language) {
        this.language = language;
        return this;
    }

    /**
     * Get the id property: Unique identifier of the recognized entity from the data source.
     * 
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: Unique identifier of the recognized entity from the data source.
     * 
     * @param id the id value to set.
     * @return the LinkedEntity object itself.
     */
    public LinkedEntity setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the url property: URL for the entity's page from the data source.
     * 
     * @return the url value.
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * Set the url property: URL for the entity's page from the data source.
     * 
     * @param url the url value to set.
     * @return the LinkedEntity object itself.
     */
    public LinkedEntity setUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the dataSource property: Data source used to extract entity linking, such as Wiki/Bing etc.
     * 
     * @return the dataSource value.
     */
    public String getDataSource() {
        return this.dataSource;
    }

    /**
     * Set the dataSource property: Data source used to extract entity linking, such as Wiki/Bing etc.
     * 
     * @param dataSource the dataSource value to set.
     * @return the LinkedEntity object itself.
     */
    public LinkedEntity setDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    /**
     * Get the bingId property: Bing Entity Search API unique identifier of the recognized entity.
     * 
     * @return the bingId value.
     */
    public String getBingId() {
        return this.bingId;
    }

    /**
     * Set the bingId property: Bing Entity Search API unique identifier of the recognized entity.
     * 
     * @param bingId the bingId value to set.
     * @return the LinkedEntity object itself.
     */
    public LinkedEntity setBingId(String bingId) {
        this.bingId = bingId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("matches", this.matches, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("dataSource", this.dataSource);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("bingId", this.bingId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LinkedEntity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LinkedEntity if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LinkedEntity.
     */
    public static LinkedEntity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LinkedEntity deserializedLinkedEntity = new LinkedEntity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedLinkedEntity.name = reader.getString();
                } else if ("matches".equals(fieldName)) {
                    List<Match> matches = reader.readArray(reader1 -> Match.fromJson(reader1));
                    deserializedLinkedEntity.matches = matches;
                } else if ("language".equals(fieldName)) {
                    deserializedLinkedEntity.language = reader.getString();
                } else if ("url".equals(fieldName)) {
                    deserializedLinkedEntity.url = reader.getString();
                } else if ("dataSource".equals(fieldName)) {
                    deserializedLinkedEntity.dataSource = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedLinkedEntity.id = reader.getString();
                } else if ("bingId".equals(fieldName)) {
                    deserializedLinkedEntity.bingId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLinkedEntity;
        });
    }
}
