// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains an input document to be analyzed by the service.
 */
@Fluent
public final class MultiLanguageInput implements JsonSerializable<MultiLanguageInput> {
    /*
     * A unique, non-empty document identifier.
     */
    private String id;

    /*
     * The input text to process.
     */
    private String text;

    /*
     * (Optional) This is the 2 letter ISO 639-1 representation of a language. For example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as default.
     */
    private String language;

    /**
     * Creates an instance of MultiLanguageInput class.
     */
    public MultiLanguageInput() {
    }

    /**
     * Get the id property: A unique, non-empty document identifier.
     * 
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: A unique, non-empty document identifier.
     * 
     * @param id the id value to set.
     * @return the MultiLanguageInput object itself.
     */
    public MultiLanguageInput setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the text property: The input text to process.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The input text to process.
     * 
     * @param text the text value to set.
     * @return the MultiLanguageInput object itself.
     */
    public MultiLanguageInput setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the language property: (Optional) This is the 2 letter ISO 639-1 representation of a language. For example,
     * use "en" for English; "es" for Spanish etc. If not set, use "en" for English as default.
     * 
     * @return the language value.
     */
    public String getLanguage() {
        return this.language;
    }

    /**
     * Set the language property: (Optional) This is the 2 letter ISO 639-1 representation of a language. For example,
     * use "en" for English; "es" for Spanish etc. If not set, use "en" for English as default.
     * 
     * @param language the language value to set.
     * @return the MultiLanguageInput object itself.
     */
    public MultiLanguageInput setLanguage(String language) {
        this.language = language;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("language", this.language);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MultiLanguageInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MultiLanguageInput if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MultiLanguageInput.
     */
    public static MultiLanguageInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MultiLanguageInput deserializedMultiLanguageInput = new MultiLanguageInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMultiLanguageInput.id = reader.getString();
                } else if ("text".equals(fieldName)) {
                    deserializedMultiLanguageInput.text = reader.getString();
                } else if ("language".equals(fieldName)) {
                    deserializedMultiLanguageInput.language = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMultiLanguageInput;
        });
    }
}
