// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The PiiEntitiesDocumentResult model.
 */
@Fluent
public class PiiEntitiesDocumentResult extends DocumentResult {
    /*
     * Returns redacted text.
     */
    private String redactedText;

    /*
     * Recognized entities in the document.
     */
    private List<Entity> entities;

    /**
     * Creates an instance of PiiEntitiesDocumentResult class.
     */
    public PiiEntitiesDocumentResult() {
    }

    /**
     * Get the redactedText property: Returns redacted text.
     * 
     * @return the redactedText value.
     */
    public String getRedactedText() {
        return this.redactedText;
    }

    /**
     * Set the redactedText property: Returns redacted text.
     * 
     * @param redactedText the redactedText value to set.
     * @return the PiiEntitiesDocumentResult object itself.
     */
    public PiiEntitiesDocumentResult setRedactedText(String redactedText) {
        this.redactedText = redactedText;
        return this;
    }

    /**
     * Get the entities property: Recognized entities in the document.
     * 
     * @return the entities value.
     */
    public List<Entity> getEntities() {
        return this.entities;
    }

    /**
     * Set the entities property: Recognized entities in the document.
     * 
     * @param entities the entities value to set.
     * @return the PiiEntitiesDocumentResult object itself.
     */
    public PiiEntitiesDocumentResult setEntities(List<Entity> entities) {
        this.entities = entities;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PiiEntitiesDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PiiEntitiesDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PiiEntitiesDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeArrayField("warnings", getWarnings(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("statistics", getStatistics());
        jsonWriter.writeStringField("redactedText", this.redactedText);
        jsonWriter.writeArrayField("entities", this.entities, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PiiEntitiesDocumentResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PiiEntitiesDocumentResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PiiEntitiesDocumentResult.
     */
    public static PiiEntitiesDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PiiEntitiesDocumentResult deserializedPiiEntitiesDocumentResult = new PiiEntitiesDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPiiEntitiesDocumentResult.setId(reader.getString());
                } else if ("warnings".equals(fieldName)) {
                    List<DocumentWarning> warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedPiiEntitiesDocumentResult.setWarnings(warnings);
                } else if ("statistics".equals(fieldName)) {
                    deserializedPiiEntitiesDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                } else if ("redactedText".equals(fieldName)) {
                    deserializedPiiEntitiesDocumentResult.redactedText = reader.getString();
                } else if ("entities".equals(fieldName)) {
                    List<Entity> entities = reader.readArray(reader1 -> Entity.fromJson(reader1));
                    deserializedPiiEntitiesDocumentResult.entities = entities;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPiiEntitiesDocumentResult;
        });
    }
}
