// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The PiiEntityRecognitionLROResult model.
 */
@Fluent
public final class PiiEntityRecognitionLROResult extends AnalyzeTextLROResult {
    /*
     * Enumeration of supported Text Analysis long-running operation task results.
     */
    private AnalyzeTextLROResultsKind kind = AnalyzeTextLROResultsKind.PII_ENTITY_RECOGNITION_LRORESULTS;

    /*
     * The results property.
     */
    private PiiResult results;

    /**
     * Creates an instance of PiiEntityRecognitionLROResult class.
     */
    public PiiEntityRecognitionLROResult() {
    }

    /**
     * Get the kind property: Enumeration of supported Text Analysis long-running operation task results.
     * 
     * @return the kind value.
     */
    @Override
    public AnalyzeTextLROResultsKind getKind() {
        return this.kind;
    }

    /**
     * Get the results property: The results property.
     * 
     * @return the results value.
     */
    public PiiResult getResults() {
        return this.results;
    }

    /**
     * Set the results property: The results property.
     * 
     * @param results the results value to set.
     * @return the PiiEntityRecognitionLROResult object itself.
     */
    public PiiEntityRecognitionLROResult setResults(PiiResult results) {
        this.results = results;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PiiEntityRecognitionLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PiiEntityRecognitionLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PiiEntityRecognitionLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastUpdateDateTime",
            getLastUpdateDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getLastUpdateDateTime()));
        jsonWriter.writeStringField("status", getStatus() == null ? null : getStatus().toString());
        jsonWriter.writeStringField("taskName", getTaskName());
        jsonWriter.writeJsonField("results", this.results);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PiiEntityRecognitionLROResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PiiEntityRecognitionLROResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PiiEntityRecognitionLROResult.
     */
    public static PiiEntityRecognitionLROResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PiiEntityRecognitionLROResult deserializedPiiEntityRecognitionLROResult
                = new PiiEntityRecognitionLROResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedPiiEntityRecognitionLROResult.setLastUpdateDateTime(
                        reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                } else if ("status".equals(fieldName)) {
                    deserializedPiiEntityRecognitionLROResult.setStatus(State.fromString(reader.getString()));
                } else if ("taskName".equals(fieldName)) {
                    deserializedPiiEntityRecognitionLROResult.setTaskName(reader.getString());
                } else if ("results".equals(fieldName)) {
                    deserializedPiiEntityRecognitionLROResult.results = PiiResult.fromJson(reader);
                } else if ("kind".equals(fieldName)) {
                    deserializedPiiEntityRecognitionLROResult.kind
                        = AnalyzeTextLROResultsKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPiiEntityRecognitionLROResult;
        });
    }
}
