// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters object for a text analysis task using pre-built models.
 */
@Fluent
public class PreBuiltTaskParameters extends TaskParameters {
    /*
     * The modelVersion property.
     */
    private String modelVersion;

    /**
     * Creates an instance of PreBuiltTaskParameters class.
     */
    public PreBuiltTaskParameters() {
    }

    /**
     * Get the modelVersion property: The modelVersion property.
     * 
     * @return the modelVersion value.
     */
    public String getModelVersion() {
        return this.modelVersion;
    }

    /**
     * Set the modelVersion property: The modelVersion property.
     * 
     * @param modelVersion the modelVersion value to set.
     * @return the PreBuiltTaskParameters object itself.
     */
    public PreBuiltTaskParameters setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PreBuiltTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("loggingOptOut", isLoggingOptOut());
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PreBuiltTaskParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PreBuiltTaskParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PreBuiltTaskParameters.
     */
    public static PreBuiltTaskParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PreBuiltTaskParameters deserializedPreBuiltTaskParameters = new PreBuiltTaskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("loggingOptOut".equals(fieldName)) {
                    deserializedPreBuiltTaskParameters.setLoggingOptOut(reader.getNullable(JsonReader::getBoolean));
                } else if ("modelVersion".equals(fieldName)) {
                    deserializedPreBuiltTaskParameters.modelVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPreBuiltTaskParameters;
        });
    }
}
