// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * if showStats=true was specified in the request this field will contain information about the request payload.
 */
@Fluent
public final class RequestStatistics implements JsonSerializable<RequestStatistics> {
    /*
     * Number of documents submitted in the request.
     */
    private int documentsCount;

    /*
     * Number of valid documents. This excludes empty, over-size limit or non-supported languages documents.
     */
    private int validDocumentsCount;

    /*
     * Number of invalid documents. This includes empty, over-size limit or non-supported languages documents.
     */
    private int erroneousDocumentsCount;

    /*
     * Number of transactions for the request.
     */
    private long transactionsCount;

    /**
     * Creates an instance of RequestStatistics class.
     */
    public RequestStatistics() {
    }

    /**
     * Get the documentsCount property: Number of documents submitted in the request.
     * 
     * @return the documentsCount value.
     */
    public int getDocumentsCount() {
        return this.documentsCount;
    }

    /**
     * Set the documentsCount property: Number of documents submitted in the request.
     * 
     * @param documentsCount the documentsCount value to set.
     * @return the RequestStatistics object itself.
     */
    public RequestStatistics setDocumentsCount(int documentsCount) {
        this.documentsCount = documentsCount;
        return this;
    }

    /**
     * Get the validDocumentsCount property: Number of valid documents. This excludes empty, over-size limit or
     * non-supported languages documents.
     * 
     * @return the validDocumentsCount value.
     */
    public int getValidDocumentsCount() {
        return this.validDocumentsCount;
    }

    /**
     * Set the validDocumentsCount property: Number of valid documents. This excludes empty, over-size limit or
     * non-supported languages documents.
     * 
     * @param validDocumentsCount the validDocumentsCount value to set.
     * @return the RequestStatistics object itself.
     */
    public RequestStatistics setValidDocumentsCount(int validDocumentsCount) {
        this.validDocumentsCount = validDocumentsCount;
        return this;
    }

    /**
     * Get the erroneousDocumentsCount property: Number of invalid documents. This includes empty, over-size limit or
     * non-supported languages documents.
     * 
     * @return the erroneousDocumentsCount value.
     */
    public int getErroneousDocumentsCount() {
        return this.erroneousDocumentsCount;
    }

    /**
     * Set the erroneousDocumentsCount property: Number of invalid documents. This includes empty, over-size limit or
     * non-supported languages documents.
     * 
     * @param erroneousDocumentsCount the erroneousDocumentsCount value to set.
     * @return the RequestStatistics object itself.
     */
    public RequestStatistics setErroneousDocumentsCount(int erroneousDocumentsCount) {
        this.erroneousDocumentsCount = erroneousDocumentsCount;
        return this;
    }

    /**
     * Get the transactionsCount property: Number of transactions for the request.
     * 
     * @return the transactionsCount value.
     */
    public long getTransactionsCount() {
        return this.transactionsCount;
    }

    /**
     * Set the transactionsCount property: Number of transactions for the request.
     * 
     * @param transactionsCount the transactionsCount value to set.
     * @return the RequestStatistics object itself.
     */
    public RequestStatistics setTransactionsCount(long transactionsCount) {
        this.transactionsCount = transactionsCount;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("documentsCount", this.documentsCount);
        jsonWriter.writeIntField("validDocumentsCount", this.validDocumentsCount);
        jsonWriter.writeIntField("erroneousDocumentsCount", this.erroneousDocumentsCount);
        jsonWriter.writeLongField("transactionsCount", this.transactionsCount);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RequestStatistics from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RequestStatistics if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RequestStatistics.
     */
    public static RequestStatistics fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RequestStatistics deserializedRequestStatistics = new RequestStatistics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("documentsCount".equals(fieldName)) {
                    deserializedRequestStatistics.documentsCount = reader.getInt();
                } else if ("validDocumentsCount".equals(fieldName)) {
                    deserializedRequestStatistics.validDocumentsCount = reader.getInt();
                } else if ("erroneousDocumentsCount".equals(fieldName)) {
                    deserializedRequestStatistics.erroneousDocumentsCount = reader.getInt();
                } else if ("transactionsCount".equals(fieldName)) {
                    deserializedRequestStatistics.transactionsCount = reader.getLong();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRequestStatistics;
        });
    }
}
