// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The SentimentDocumentResult model.
 */
@Fluent
public class SentimentDocumentResult extends DocumentResult {
    /*
     * Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
     */
    private DocumentSentimentValue sentiment;

    /*
     * Document level sentiment confidence scores between 0 and 1 for each sentiment class.
     */
    private SentimentConfidenceScorePerLabel confidenceScores;

    /*
     * Sentence level sentiment analysis.
     */
    private List<SentenceSentiment> sentences;

    /**
     * Creates an instance of SentimentDocumentResult class.
     */
    public SentimentDocumentResult() {
    }

    /**
     * Get the sentiment property: Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
     * 
     * @return the sentiment value.
     */
    public DocumentSentimentValue getSentiment() {
        return this.sentiment;
    }

    /**
     * Set the sentiment property: Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
     * 
     * @param sentiment the sentiment value to set.
     * @return the SentimentDocumentResult object itself.
     */
    public SentimentDocumentResult setSentiment(DocumentSentimentValue sentiment) {
        this.sentiment = sentiment;
        return this;
    }

    /**
     * Get the confidenceScores property: Document level sentiment confidence scores between 0 and 1 for each sentiment
     * class.
     * 
     * @return the confidenceScores value.
     */
    public SentimentConfidenceScorePerLabel getConfidenceScores() {
        return this.confidenceScores;
    }

    /**
     * Set the confidenceScores property: Document level sentiment confidence scores between 0 and 1 for each sentiment
     * class.
     * 
     * @param confidenceScores the confidenceScores value to set.
     * @return the SentimentDocumentResult object itself.
     */
    public SentimentDocumentResult setConfidenceScores(SentimentConfidenceScorePerLabel confidenceScores) {
        this.confidenceScores = confidenceScores;
        return this;
    }

    /**
     * Get the sentences property: Sentence level sentiment analysis.
     * 
     * @return the sentences value.
     */
    public List<SentenceSentiment> getSentences() {
        return this.sentences;
    }

    /**
     * Set the sentences property: Sentence level sentiment analysis.
     * 
     * @param sentences the sentences value to set.
     * @return the SentimentDocumentResult object itself.
     */
    public SentimentDocumentResult setSentences(List<SentenceSentiment> sentences) {
        this.sentences = sentences;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SentimentDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeArrayField("warnings", getWarnings(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("statistics", getStatistics());
        jsonWriter.writeStringField("sentiment", this.sentiment == null ? null : this.sentiment.toString());
        jsonWriter.writeJsonField("confidenceScores", this.confidenceScores);
        jsonWriter.writeArrayField("sentences", this.sentences, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SentimentDocumentResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SentimentDocumentResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SentimentDocumentResult.
     */
    public static SentimentDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SentimentDocumentResult deserializedSentimentDocumentResult = new SentimentDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSentimentDocumentResult.setId(reader.getString());
                } else if ("warnings".equals(fieldName)) {
                    List<DocumentWarning> warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedSentimentDocumentResult.setWarnings(warnings);
                } else if ("statistics".equals(fieldName)) {
                    deserializedSentimentDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                } else if ("sentiment".equals(fieldName)) {
                    deserializedSentimentDocumentResult.sentiment
                        = DocumentSentimentValue.fromString(reader.getString());
                } else if ("confidenceScores".equals(fieldName)) {
                    deserializedSentimentDocumentResult.confidenceScores
                        = SentimentConfidenceScorePerLabel.fromJson(reader);
                } else if ("sentences".equals(fieldName)) {
                    List<SentenceSentiment> sentences
                        = reader.readArray(reader1 -> SentenceSentiment.fromJson(reader1));
                    deserializedSentimentDocumentResult.sentences = sentences;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSentimentDocumentResult;
        });
    }
}
