// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the method used to interpret string offsets. Defaults to Text Elements (Graphemes) according to Unicode
 * v8.0.0. For additional information see https://aka.ms/text-analytics-offsets.
 */
public final class StringIndexType extends ExpandableStringEnum<StringIndexType> {
    /**
     * Returned offset and length values will correspond to TextElements (Graphemes and Grapheme clusters) confirming to
     * the Unicode 8.0.0 standard. Use this option if your application is written in .Net Framework or .Net Core and you
     * will be using StringInfo.
     */
    public static final StringIndexType TEXT_ELEMENTS_V8 = fromString("TextElements_v8");

    /**
     * Returned offset and length values will correspond to Unicode code points. Use this option if your application is
     * written in a language that support Unicode, for example Python.
     */
    public static final StringIndexType UNICODE_CODE_POINT = fromString("UnicodeCodePoint");

    /**
     * Returned offset and length values will correspond to UTF-16 code units. Use this option if your application is
     * written in a language that support Unicode, for example Java, JavaScript.
     */
    public static final StringIndexType UTF16CODE_UNIT = fromString("Utf16CodeUnit");

    /**
     * Creates a new instance of StringIndexType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public StringIndexType() {
    }

    /**
     * Creates or finds a StringIndexType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding StringIndexType.
     */
    public static StringIndexType fromString(String name) {
        return fromString(name, StringIndexType.class);
    }

    /**
     * Gets known StringIndexType values.
     * 
     * @return known StringIndexType values.
     */
    public static Collection<StringIndexType> values() {
        return values(StringIndexType.class);
    }
}
