/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.Entity;
import com.azure.ai.textanalytics.implementation.models.PiiEntitiesDocumentResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class PiiResultDocumentsItem
extends PiiEntitiesDocumentResult {
    @Override
    public PiiResultDocumentsItem setRedactedText(String redactedText) {
        super.setRedactedText(redactedText);
        return this;
    }

    @Override
    public PiiResultDocumentsItem setEntities(List<Entity> entities) {
        super.setEntities(entities);
        return this;
    }

    @Override
    public PiiResultDocumentsItem setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public PiiResultDocumentsItem setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings((List)warnings);
        return this;
    }

    @Override
    public PiiResultDocumentsItem setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("redactedText", this.getRedactedText());
        jsonWriter.writeArrayField("entities", this.getEntities(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        return jsonWriter.writeEndObject();
    }

    public static PiiResultDocumentsItem fromJson(JsonReader jsonReader) throws IOException {
        return (PiiResultDocumentsItem)jsonReader.readObject(reader -> {
            PiiResultDocumentsItem deserializedPiiResultDocumentsItem = new PiiResultDocumentsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPiiResultDocumentsItem.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedPiiResultDocumentsItem.setWarnings(warnings);
                    continue;
                }
                if ("redactedText".equals(fieldName)) {
                    deserializedPiiResultDocumentsItem.setRedactedText(reader.getString());
                    continue;
                }
                if ("entities".equals(fieldName)) {
                    List entities = reader.readArray(reader1 -> Entity.fromJson(reader1));
                    deserializedPiiResultDocumentsItem.setEntities(entities);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedPiiResultDocumentsItem.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPiiResultDocumentsItem;
        });
    }
}

