/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.CustomLabelClassificationResultDocumentsItem;
import com.azure.ai.textanalytics.implementation.models.CustomResult;
import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CustomLabelClassificationResult
extends CustomResult {
    private List<CustomLabelClassificationResultDocumentsItem> documents;

    public List<CustomLabelClassificationResultDocumentsItem> getDocuments() {
        return this.documents;
    }

    public CustomLabelClassificationResult setDocuments(List<CustomLabelClassificationResultDocumentsItem> documents) {
        this.documents = documents;
        return this;
    }

    @Override
    public CustomLabelClassificationResult setErrors(List<DocumentError> errors) {
        super.setErrors(errors);
        return this;
    }

    @Override
    public CustomLabelClassificationResult setStatistics(RequestStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public CustomLabelClassificationResult setProjectName(String projectName) {
        super.setProjectName(projectName);
        return this;
    }

    @Override
    public CustomLabelClassificationResult setDeploymentName(String deploymentName) {
        super.setDeploymentName(deploymentName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", this.getErrors(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("projectName", this.getProjectName());
        jsonWriter.writeStringField("deploymentName", this.getDeploymentName());
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomLabelClassificationResult fromJson(JsonReader jsonReader) throws IOException {
        return (CustomLabelClassificationResult)jsonReader.readObject(reader -> {
            CustomLabelClassificationResult deserializedCustomLabelClassificationResult = new CustomLabelClassificationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    deserializedCustomLabelClassificationResult.setErrors(errors);
                    continue;
                }
                if ("projectName".equals(fieldName)) {
                    deserializedCustomLabelClassificationResult.setProjectName(reader.getString());
                    continue;
                }
                if ("deploymentName".equals(fieldName)) {
                    deserializedCustomLabelClassificationResult.setDeploymentName(reader.getString());
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedCustomLabelClassificationResult.setStatistics(RequestStatistics.fromJson(reader));
                    continue;
                }
                if ("documents".equals(fieldName)) {
                    List documents;
                    deserializedCustomLabelClassificationResult.documents = documents = reader.readArray(reader1 -> CustomLabelClassificationResultDocumentsItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomLabelClassificationResult;
        });
    }
}

