/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.SingleClassificationDocument;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CustomSingleClassificationResult
implements JsonSerializable<CustomSingleClassificationResult> {
    private List<SingleClassificationDocument> documents;
    private List<DocumentError> errors;
    private RequestStatistics statistics;
    private String projectName;
    private String deploymentName;

    public List<SingleClassificationDocument> getDocuments() {
        return this.documents;
    }

    public CustomSingleClassificationResult setDocuments(List<SingleClassificationDocument> documents) {
        this.documents = documents;
        return this;
    }

    public List<DocumentError> getErrors() {
        return this.errors;
    }

    public CustomSingleClassificationResult setErrors(List<DocumentError> errors) {
        this.errors = errors;
        return this;
    }

    public RequestStatistics getStatistics() {
        return this.statistics;
    }

    public CustomSingleClassificationResult setStatistics(RequestStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public CustomSingleClassificationResult setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public CustomSingleClassificationResult setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        jsonWriter.writeStringField("projectName", this.projectName);
        jsonWriter.writeStringField("deploymentName", this.deploymentName);
        return jsonWriter.writeEndObject();
    }

    public static CustomSingleClassificationResult fromJson(JsonReader jsonReader) throws IOException {
        return (CustomSingleClassificationResult)jsonReader.readObject(reader -> {
            CustomSingleClassificationResult deserializedCustomSingleClassificationResult = new CustomSingleClassificationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("documents".equals(fieldName)) {
                    deserializedCustomSingleClassificationResult.documents = reader.readArray(reader1 -> SingleClassificationDocument.fromJson(reader1));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    deserializedCustomSingleClassificationResult.errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedCustomSingleClassificationResult.statistics = RequestStatistics.fromJson(reader);
                    continue;
                }
                if ("projectName".equals(fieldName)) {
                    deserializedCustomSingleClassificationResult.projectName = reader.getString();
                    continue;
                }
                if ("deploymentName".equals(fieldName)) {
                    deserializedCustomSingleClassificationResult.deploymentName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomSingleClassificationResult;
        });
    }
}

