/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTaskKind;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationTaskParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ExtractiveSummarizationLROTask
extends AnalyzeTextLROTask {
    private AnalyzeTextLROTaskKind kind = AnalyzeTextLROTaskKind.EXTRACTIVE_SUMMARIZATION;
    private ExtractiveSummarizationTaskParameters parameters;

    @Override
    public AnalyzeTextLROTaskKind getKind() {
        return this.kind;
    }

    public ExtractiveSummarizationTaskParameters getParameters() {
        return this.parameters;
    }

    public ExtractiveSummarizationLROTask setParameters(ExtractiveSummarizationTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public ExtractiveSummarizationLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static ExtractiveSummarizationLROTask fromJson(JsonReader jsonReader) throws IOException {
        return (ExtractiveSummarizationLROTask)jsonReader.readObject(reader -> {
            ExtractiveSummarizationLROTask deserializedExtractiveSummarizationLROTask = new ExtractiveSummarizationLROTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("taskName".equals(fieldName)) {
                    deserializedExtractiveSummarizationLROTask.setTaskName(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedExtractiveSummarizationLROTask.kind = AnalyzeTextLROTaskKind.fromString(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedExtractiveSummarizationLROTask.parameters = ExtractiveSummarizationTaskParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExtractiveSummarizationLROTask;
        });
    }
}

