/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;

public class JobMetadata
implements JsonSerializable<JobMetadata> {
    private String displayName;
    private OffsetDateTime createdDateTime;
    private OffsetDateTime expirationDateTime;
    private UUID jobId;
    private OffsetDateTime lastUpdateDateTime;
    private State status;

    public String getDisplayName() {
        return this.displayName;
    }

    public JobMetadata setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public JobMetadata setCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public JobMetadata setExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    public UUID getJobId() {
        return this.jobId;
    }

    public JobMetadata setJobId(UUID jobId) {
        this.jobId = jobId;
        return this;
    }

    public OffsetDateTime getLastUpdateDateTime() {
        return this.lastUpdateDateTime;
    }

    public JobMetadata setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        this.lastUpdateDateTime = lastUpdateDateTime;
        return this;
    }

    public State getStatus() {
        return this.status;
    }

    public JobMetadata setStatus(State status) {
        this.status = status;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("expirationDateTime", this.expirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeStringField("jobId", this.jobId == null ? null : this.jobId.toString());
        jsonWriter.writeStringField("lastUpdateDateTime", this.lastUpdateDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdateDateTime));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static JobMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (JobMetadata)jsonReader.readObject(reader -> {
            JobMetadata jobMetadata = new JobMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    jobMetadata.displayName = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    jobMetadata.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    jobMetadata.expirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    jobMetadata.jobId = UUID.fromString(reader.getString());
                    continue;
                }
                if ("lastUpdateDateTime".equals(fieldName)) {
                    jobMetadata.lastUpdateDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    jobMetadata.status = State.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return jobMetadata;
        });
    }
}

