/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.Error;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class JobState
implements JsonSerializable<JobState> {
    private String displayName;
    private OffsetDateTime createdDateTime;
    private OffsetDateTime expirationDateTime;
    private String jobId;
    private OffsetDateTime lastUpdatedDateTime;
    private State status;
    private List<Error> errors;
    private String nextLink;

    public String getDisplayName() {
        return this.displayName;
    }

    public JobState setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public JobState setCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public JobState setExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public JobState setJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public JobState setLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        return this;
    }

    public State getStatus() {
        return this.status;
    }

    public JobState setStatus(State status) {
        this.status = status;
        return this;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public JobState setErrors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public String getNextLink() {
        return this.nextLink;
    }

    public JobState setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("jobId", this.jobId);
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("expirationDateTime", this.expirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static JobState fromJson(JsonReader jsonReader) throws IOException {
        return (JobState)jsonReader.readObject(reader -> {
            JobState deserializedJobState = new JobState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdDateTime".equals(fieldName)) {
                    deserializedJobState.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedJobState.jobId = reader.getString();
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedJobState.lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedJobState.status = State.fromString(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedJobState.displayName = reader.getString();
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    deserializedJobState.expirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedJobState.errors = errors = reader.readArray(reader1 -> Error.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedJobState.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobState;
        });
    }
}

