/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.DocumentLanguage;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class LanguageResult
implements JsonSerializable<LanguageResult> {
    private List<DocumentLanguage> documents;
    private List<DocumentError> errors;
    private RequestStatistics statistics;
    private String modelVersion;

    public List<DocumentLanguage> getDocuments() {
        return this.documents;
    }

    public LanguageResult setDocuments(List<DocumentLanguage> documents) {
        this.documents = documents;
        return this;
    }

    public List<DocumentError> getErrors() {
        return this.errors;
    }

    public LanguageResult setErrors(List<DocumentError> errors) {
        this.errors = errors;
        return this;
    }

    public RequestStatistics getStatistics() {
        return this.statistics;
    }

    public LanguageResult setStatistics(RequestStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public LanguageResult setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        return jsonWriter.writeEndObject();
    }

    public static LanguageResult fromJson(JsonReader jsonReader) throws IOException {
        return (LanguageResult)jsonReader.readObject(reader -> {
            LanguageResult deserializedLanguageResult = new LanguageResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("documents".equals(fieldName)) {
                    deserializedLanguageResult.documents = reader.readArray(reader1 -> DocumentLanguage.fromJson(reader1));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    deserializedLanguageResult.errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedLanguageResult.statistics = RequestStatistics.fromJson(reader);
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    deserializedLanguageResult.modelVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLanguageResult;
        });
    }
}

