// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.translation.text.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * An object describing the detected language.
 */
@Immutable
public final class DetectedLanguage {

    /*
     * A string representing the code of the detected language.
     */
    @Generated
    @JsonProperty(value = "language")
    private final String language;

    /*
     * A float value indicating the confidence in the result.
     * The score is between zero and one and a low score indicates a low confidence.
     */
    @Generated
    @JsonProperty(value = "score")
    private final double confidence;

    /**
     * Creates an instance of DetectedLanguage class.
     *
     * @param language the language value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    @JsonCreator
    private DetectedLanguage(@JsonProperty(value = "language") String language,
        @JsonProperty(value = "score") double confidence) {
        this.language = language;
        this.confidence = confidence;
    }

    /**
     * Get the language property: A string representing the code of the detected language.
     *
     * @return the language value.
     */
    @Generated
    public String getLanguage() {
        return this.language;
    }

    /**
     * Get the confidence property: A float value indicating the confidence in the result.
     * The score is between zero and one and a low score indicates a low confidence.
     *
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }
}
