// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.translation.text.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Dictionary Example.
 */
@Immutable
public final class DictionaryExample {

    /*
     * The string to concatenate before the value of sourceTerm to form a complete example.
     * Do not add a space character, since it is already there when it should be.
     * This value may be an empty string.
     */
    @Generated
    @JsonProperty(value = "sourcePrefix")
    private final String sourcePrefix;

    /*
     * A string equal to the actual term looked up. The string is added with sourcePrefix
     * and sourceSuffix to form the complete example. Its value is separated so it can be
     * marked in a user interface, e.g., by bolding it.
     */
    @Generated
    @JsonProperty(value = "sourceTerm")
    private final String sourceTerm;

    /*
     * The string to concatenate after the value of sourceTerm to form a complete example.
     * Do not add a space character, since it is already there when it should be.
     * This value may be an empty string.
     */
    @Generated
    @JsonProperty(value = "sourceSuffix")
    private final String sourceSuffix;

    /*
     * A string similar to sourcePrefix but for the target.
     */
    @Generated
    @JsonProperty(value = "targetPrefix")
    private final String targetPrefix;

    /*
     * A string similar to sourceTerm but for the target.
     */
    @Generated
    @JsonProperty(value = "targetTerm")
    private final String targetTerm;

    /*
     * A string similar to sourceSuffix but for the target.
     */
    @Generated
    @JsonProperty(value = "targetSuffix")
    private final String targetSuffix;

    /**
     * Creates an instance of DictionaryExample class.
     *
     * @param sourcePrefix the sourcePrefix value to set.
     * @param sourceTerm the sourceTerm value to set.
     * @param sourceSuffix the sourceSuffix value to set.
     * @param targetPrefix the targetPrefix value to set.
     * @param targetTerm the targetTerm value to set.
     * @param targetSuffix the targetSuffix value to set.
     */
    @Generated
    @JsonCreator
    private DictionaryExample(@JsonProperty(value = "sourcePrefix") String sourcePrefix,
        @JsonProperty(value = "sourceTerm") String sourceTerm,
        @JsonProperty(value = "sourceSuffix") String sourceSuffix,
        @JsonProperty(value = "targetPrefix") String targetPrefix,
        @JsonProperty(value = "targetTerm") String targetTerm,
        @JsonProperty(value = "targetSuffix") String targetSuffix) {
        this.sourcePrefix = sourcePrefix;
        this.sourceTerm = sourceTerm;
        this.sourceSuffix = sourceSuffix;
        this.targetPrefix = targetPrefix;
        this.targetTerm = targetTerm;
        this.targetSuffix = targetSuffix;
    }

    /**
     * Get the sourcePrefix property: The string to concatenate before the value of sourceTerm to form a complete
     * example.
     * Do not add a space character, since it is already there when it should be.
     * This value may be an empty string.
     *
     * @return the sourcePrefix value.
     */
    @Generated
    public String getSourcePrefix() {
        return this.sourcePrefix;
    }

    /**
     * Get the sourceTerm property: A string equal to the actual term looked up. The string is added with sourcePrefix
     * and sourceSuffix to form the complete example. Its value is separated so it can be
     * marked in a user interface, e.g., by bolding it.
     *
     * @return the sourceTerm value.
     */
    @Generated
    public String getSourceTerm() {
        return this.sourceTerm;
    }

    /**
     * Get the sourceSuffix property: The string to concatenate after the value of sourceTerm to form a complete
     * example.
     * Do not add a space character, since it is already there when it should be.
     * This value may be an empty string.
     *
     * @return the sourceSuffix value.
     */
    @Generated
    public String getSourceSuffix() {
        return this.sourceSuffix;
    }

    /**
     * Get the targetPrefix property: A string similar to sourcePrefix but for the target.
     *
     * @return the targetPrefix value.
     */
    @Generated
    public String getTargetPrefix() {
        return this.targetPrefix;
    }

    /**
     * Get the targetTerm property: A string similar to sourceTerm but for the target.
     *
     * @return the targetTerm value.
     */
    @Generated
    public String getTargetTerm() {
        return this.targetTerm;
    }

    /**
     * Get the targetSuffix property: A string similar to sourceSuffix but for the target.
     *
     * @return the targetSuffix value.
     */
    @Generated
    public String getTargetSuffix() {
        return this.targetSuffix;
    }
}
