// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.translation.text.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Dictionary Example element.
 */
@Immutable
public final class DictionaryExampleItem {

    /*
     * A string giving the normalized form of the source term. Generally, this should be identical
     * to the value of the Text field at the matching list index in the body of the request.
     */
    @Generated
    @JsonProperty(value = "normalizedSource")
    private final String normalizedSource;

    /*
     * A string giving the normalized form of the target term. Generally, this should be identical
     * to the value of the Translation field at the matching list index in the body of the request.
     */
    @Generated
    @JsonProperty(value = "normalizedTarget")
    private final String normalizedTarget;

    /*
     * A list of examples for the (source term, target term) pair.
     */
    @Generated
    @JsonProperty(value = "examples")
    private final List<DictionaryExample> examples;

    /**
     * Creates an instance of DictionaryExampleItem class.
     *
     * @param normalizedSource the normalizedSource value to set.
     * @param normalizedTarget the normalizedTarget value to set.
     * @param examples the examples value to set.
     */
    @Generated
    @JsonCreator
    private DictionaryExampleItem(@JsonProperty(value = "normalizedSource") String normalizedSource,
        @JsonProperty(value = "normalizedTarget") String normalizedTarget,
        @JsonProperty(value = "examples") List<DictionaryExample> examples) {
        this.normalizedSource = normalizedSource;
        this.normalizedTarget = normalizedTarget;
        this.examples = examples;
    }

    /**
     * Get the normalizedSource property: A string giving the normalized form of the source term. Generally, this should
     * be identical
     * to the value of the Text field at the matching list index in the body of the request.
     *
     * @return the normalizedSource value.
     */
    @Generated
    public String getNormalizedSource() {
        return this.normalizedSource;
    }

    /**
     * Get the normalizedTarget property: A string giving the normalized form of the target term. Generally, this should
     * be identical
     * to the value of the Translation field at the matching list index in the body of the request.
     *
     * @return the normalizedTarget value.
     */
    @Generated
    public String getNormalizedTarget() {
        return this.normalizedTarget;
    }

    /**
     * Get the examples property: A list of examples for the (source term, target term) pair.
     *
     * @return the examples value.
     */
    @Generated
    public List<DictionaryExample> getExamples() {
        return this.examples;
    }
}
