// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.translation.text.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Translator languages scopes.
 */
public final class LanguageScope extends ExpandableStringEnum<LanguageScope> {

    /**
     * Static value Translation for LanguageScope.
     */
    public static final LanguageScope TRANSLATION = fromString("Translation");

    /**
     * Static value Transliteration for LanguageScope.
     */
    public static final LanguageScope TRANSLITERATION = fromString("Transliteration");

    /**
     * Static value Dictionary for LanguageScope.
     */
    public static final LanguageScope DICTIONARY = fromString("Dictionary");

    /**
     * Creates a new instance of LanguageScope value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LanguageScope() {
    }

    /**
     * Creates or finds a LanguageScope from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding LanguageScope.
     */
    @JsonCreator
    public static LanguageScope fromString(String name) {
        return fromString(name, LanguageScope.class);
    }

    /**
     * Gets known LanguageScope values.
     *
     * @return known LanguageScope values.
     */
    public static Collection<LanguageScope> values() {
        return values(LanguageScope.class);
    }
}
