// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.translation.text.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Translator profanity markers.
 */
public enum ProfanityMarker {
    /**
     * Profanity is marked with asterisk.
     */
    ASTERISK("Asterisk"),

    /**
     * Profanity is marked with the tags.
     */
    TAG("Tag");

    /**
     * The actual serialized value for a ProfanityMarker instance.
     */
    private final String value;

    ProfanityMarker(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ProfanityMarker instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ProfanityMarker object, or null if unable to parse.
     */
    @JsonCreator
    public static ProfanityMarker fromString(String value) {
        if (value == null) {
            return null;
        }
        ProfanityMarker[] items = ProfanityMarker.values();
        for (ProfanityMarker item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
