// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.translation.text.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * An object returning sentence boundaries in the input and output texts.
 */
@Immutable
public final class SentenceBoundaries {

    /*
     * An integer array representing the lengths of the sentences in the input text.
     * The length of the array is the number of sentences, and the values are the length of each sentence.
     */
    @Generated
    @JsonProperty(value = "srcSentLen")
    private final List<Integer> sourceSentencesLengths;

    /*
     * An integer array representing the lengths of the sentences in the translated text.
     * The length of the array is the number of sentences, and the values are the length of each sentence.
     */
    @Generated
    @JsonProperty(value = "transSentLen")
    private final List<Integer> translatedSentencesLengths;

    /**
     * Creates an instance of SentenceBoundaries class.
     *
     * @param sourceSentencesLengths the sourceSentencesLengths value to set.
     * @param translatedSentencesLengths the translatedSentencesLengths value to set.
     */
    @Generated
    @JsonCreator
    private SentenceBoundaries(@JsonProperty(value = "srcSentLen") List<Integer> sourceSentencesLengths,
        @JsonProperty(value = "transSentLen") List<Integer> translatedSentencesLengths) {
        this.sourceSentencesLengths = sourceSentencesLengths;
        this.translatedSentencesLengths = translatedSentencesLengths;
    }

    /**
     * Get the sourceSentencesLengths property: An integer array representing the lengths of the sentences in the input
     * text.
     * The length of the array is the number of sentences, and the values are the length of each sentence.
     *
     * @return the sourceSentencesLengths value.
     */
    @Generated
    public List<Integer> getSourceSentencesLengths() {
        return this.sourceSentencesLengths;
    }

    /**
     * Get the translatedSentencesLengths property: An integer array representing the lengths of the sentences in the
     * translated text.
     * The length of the array is the number of sentences, and the values are the length of each sentence.
     *
     * @return the translatedSentencesLengths value.
     */
    @Generated
    public List<Integer> getTranslatedSentencesLengths() {
        return this.translatedSentencesLengths;
    }
}
