// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.translation.text.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Alignment information object.
 */
@Immutable
public final class TranslatedTextAlignment {

    /*
     * Maps input text to translated text. The alignment information is only provided when the request
     * parameter includeAlignment is true. Alignment is returned as a string value of the following
     * format: [[SourceTextStartIndex]:[SourceTextEndIndex]–[TgtTextStartIndex]:[TgtTextEndIndex]].
     * The colon separates start and end index, the dash separates the languages, and space separates the words.
     * One word may align with zero, one, or multiple words in the other language, and the aligned words may
     * be non-contiguous. When no alignment information is available, the alignment element will be empty.
     */
    @Generated
    @JsonProperty(value = "proj")
    private final String projections;

    /**
     * Creates an instance of TranslatedTextAlignment class.
     *
     * @param projections the projections value to set.
     */
    @Generated
    @JsonCreator
    private TranslatedTextAlignment(@JsonProperty(value = "proj") String projections) {
        this.projections = projections;
    }

    /**
     * Get the projections property: Maps input text to translated text. The alignment information is only provided when
     * the request
     * parameter includeAlignment is true. Alignment is returned as a string value of the following
     * format: [[SourceTextStartIndex]:[SourceTextEndIndex]–[TgtTextStartIndex]:[TgtTextEndIndex]].
     * The colon separates start and end index, the dash separates the languages, and space separates the words.
     * One word may align with zero, one, or multiple words in the other language, and the aligned words may
     * be non-contiguous. When no alignment information is available, the alignment element will be empty.
     *
     * @return the projections value.
     */
    @Generated
    public String getProjections() {
        return this.projections;
    }
}
